package com.xebialabs.deployit.plugin.test.yak.ci;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.test.yak.step.StartYakServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.StopYakServerStep;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class YakServer extends BaseContainer {
    
    @Contributor
    public void stopAndStartYaks(Deltas deltas, DeploymentPlanningContext result) {
        logger.debug("Stopping and starting all Yak servers");
        Set<YakServer> yakServers = gatherYakServers(deltas.getDeltas());
        for (YakServer yakServer : yakServers) {
        	result.addStep(new StopYakServerStep(this));
            result.addStep(new StartYakServerStep(yakServer));
        }
    }

    private Set<YakServer> gatherYakServers(List<Delta> operations) {
        Set<YakServer> servers = new TreeSet<YakServer>();
        for (Delta operation : operations) {
            if (operation.getDeployed() instanceof RestartRequiringDeployedYakFile && operation.getDeployed().getContainer() instanceof YakServer) {
                servers.add((YakServer) operation.getDeployed().getContainer());
            }
        }
        return servers;
    }

    private static final Logger logger = LoggerFactory.getLogger(YakServer.class);
}
