package com.xebialabs.deployit.plugin.test.v3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;

@Metadata(virtual = false)
public class DeployedEarModule extends BaseDeployedArtifact<MyDummyEar, DummyJeeServer> {

	@Override
	public void initFile(PlaceholderReplacer replacer) {
		OverthereFile file = getDeployable().getFile();
		InputStreamReader inputStreamReader = new InputStreamReader(file.getInputStream());
		OutputStreamWriter writer = null;
		try {
			File deployedEarModule = File.createTempFile("deployedEarModule", ".txt");
			setFile(LocalFile.valueOf(deployedEarModule));
			writer = new OutputStreamWriter(new FileOutputStream(deployedEarModule));

			replacer.replace(inputStreamReader, writer, getPlaceholders());
		} catch (FileNotFoundException e) {
			throw new RuntimeIOException(e);
		} catch (IOException e) {
			throw new RuntimeIOException(e);
		} finally {
			Closeables.closeQuietly(inputStreamReader);
			Closeables.closeQuietly(writer);
		}
	}
}
