package ai.digital.deploy.metrics.config

import ai.digital.deploy.metrics.api.MetricsReportService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class MetricsReportConfig() {

  @Autowired var metricsReportService: MetricsReportService = _

  private val ZIP_FILENAME_PREFIX = "xld-usage-metrics"
  private lazy val INTERNAL_REPORTS_TO_PACK = List(
    InternalReport("ListDeployments", "json",
      () => metricsReportService.listDeployments),
    InternalReport("DeploymentsCount", "json",
      () => metricsReportService.getDeploymentsCount),
    InternalReport("PluginsCountByDeployment", "json",
      () => metricsReportService.getPluginsCountByDeployment),
    InternalReport("ListConfigurationItems", "json",
      () => metricsReportService.listConfigurationItems),
    InternalReport("ConfigurationItemsCount", "json",
      () => metricsReportService.getConfigurationItemsCount),
    InternalReport("UsersCountByCI", "json",
      () => metricsReportService.getUsersCountByCI),
    InternalReport("PluginsCountByCI", "json",
      () => metricsReportService.getPluginsCountByCI),
    InternalReport("SubFoldersCountByCI", "json",
      () => metricsReportService.getSubFoldersCountByCI)
  )

  @Bean
  def metricsAcceleratorConfiguration(): MetricsAcceleratorConfiguration = {
    MetricsAcceleratorConfiguration(ZIP_FILENAME_PREFIX, INTERNAL_REPORTS_TO_PACK)
  }
}

case class MetricsAcceleratorConfiguration(filename: String,
                                           internalReportsToPack: List[InternalReport] = List.empty)

case class InternalReport(reportName: String, fileType: String, reportSupplier: () => String)
