package ai.digital.deploy.metrics.rest

import org.joda.time.DateTime
import org.springframework.beans.factory.annotation.Autowired
import ai.digital.deploy.metrics.api._
import ai.digital.deploy.metrics.config.MetricsAcceleratorConfiguration
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xltype.serialization.util.DateUtil
import org.springframework.stereotype.Controller

import java.io.OutputStream
import jakarta.ws.rs.core.{Response, StreamingOutput}

@Controller
class DefaultJsonMetricsServiceResource(@Autowired metricsReportService: MetricsReportService,
                                        @Autowired metricsAcceleratorConfiguration: MetricsAcceleratorConfiguration)
  extends AbstractSecuredResource with DefaultJsonMetricsService {

  override def generateSupportZip(): Response = {
    checkPermission(ADMIN)

    val timestamp = DateUtil.toString(DateTime.now())
    val filename = s"${metricsAcceleratorConfiguration.filename}-$timestamp.zip"

    val stream = new StreamingOutput {
      override def write(output: OutputStream): Unit =
        metricsReportService.prepareMetricsReportZip(
          output,
          metricsAcceleratorConfiguration.internalReportsToPack)
    }

    Response
      .ok(stream)
      .header("Content-Disposition", "attachment; filename=\"" + filename + "\"")
      .build
  }


}
