package ai.digital.deploy.metrics.json

import ai.digital.deploy.metrics.model.CiCount
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{Collection => JCollection}
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ConfigurationItemsCountJsonWriter extends AbstractJsonWriter[JCollection[CiCount]] {

  private val matcher = new TypeMatcher(classOf[JCollection[_]], classOf[CiCount])

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(ciCount: JCollection[CiCount], typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(ciCount).getBytes)


  override protected def writeJson(lines: JCollection[CiCount], writer: JsonWriter): Unit = {
    writer.array
    lines.forEach { line =>
      writer.`object`()
      writer.key("path").value(line.path)
      writer.key("ciCount").value(line.ciCount)
      writer.endObject()
    }
    writer.endArray
  }
}
