package ai.digital.deploy.metrics.json

import ai.digital.deploy.metrics.model.PluginsCountByCi
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class PluginsCountByCiJsonWriter extends AbstractJsonWriter[PluginsCountByCi] {

  private val matcher = new TypeMatcher(classOf[PluginsCountByCi])

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(pluginsCountByCi: PluginsCountByCi, typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(pluginsCountByCi).getBytes)


  override protected def writeJson(line: PluginsCountByCi, writer: JsonWriter): Unit = {
    writer.array
    writer.`object`()
    writer.key("pluginsCountByCi").value(line.pluginsCountByCi)
    writer.endObject()
    writer.endArray
  }
}
