package ai.digital.deploy.metrics.json

import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class PluginsCountByDeploymentJsonWriter extends AbstractJsonWriter[Int] {

  private val matcher = new TypeMatcher(classOf[Int])

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(count: Int, typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(count).getBytes)


  override protected def writeJson(count: Int, writer: JsonWriter): Unit = {
    writer.array
    writer.`object`()
    writer.key("pluginsCountByDeployment").value(count)
    writer.endObject()
    writer.endArray
  }
}
