package ai.digital.deploy.metrics

import org.joda.time.DateTime

package model {


  case class CiMetrics(id: Int,
                       name: String,
                       ciType: String,
                       path: String,
                       createdBy: String,
                       createdAt: DateTime,
                       modifiedBy: String,
                       modifiedAt: DateTime) {
     def apply(ciId:Int, name: String, ciType: String, path: String, createdBy: String, createdAt: DateTime, modifiedBy: String,  modifiedAt: DateTime) : CiMetrics =
       CiMetrics(id, name, ciType, path, createdBy, createdAt, modifiedBy,  modifiedAt)
  }

  case class PluginMetrics(ciId: Int,
                           pluginType: String) {
    def apply(ciId: Int, pluginType: String) : PluginMetrics =
      PluginMetrics(ciId, pluginType)
  }

  case class CiPluginMetrics(id: Int,
                       name: String,
                       ciType: String,
                       path: String,
                       plugins: List[String],
                       createdBy: String,
                       createdAt: DateTime,
                       modifiedBy: String,
                       modifiedAt: DateTime) {
    def apply(ciId:Int, name: String, ciType: String, path: String, createdBy: String, plugins: List[String], createdAt: DateTime, modifiedBy: String,  modifiedAt: DateTime) : CiPluginMetrics =
      CiPluginMetrics(id, name, ciType, path, plugins, createdBy, createdAt, modifiedBy,  modifiedAt)
  }

  case class CiCount(path: String, ciCount: Long)

  case class PluginsCountByCi(pluginsCountByCi: Int)

  case class UsersCountByCi(usersCountByCi: Long)

  case class FoldersCount(path: String, foldersCount: Long)

  case class DeploymentMetrics(taskId: String,
                       ciType: String,
                       path: String,
                       plugins: List[String],
                       owner: String,
                       taskType: String,
                       startDate: DateTime,
                       status: String) {
    def apply(taskId: String, ciType: String, path: String, plugins: List[String], owner: String,
              startDate: DateTime, status: String) : DeploymentMetrics =
      DeploymentMetrics(taskId, ciType, path, plugins, owner, taskType, startDate, status)
  }

  case class DeploymentPluginMetrics(taskId: String,
                                     ciType: String) {
    def apply(taskId: String, ciType: String): DeploymentPluginMetrics =
       DeploymentPluginMetrics(taskId, ciType)
  }
  case class DefaultCiMetrics(folderPath: String,
                              numberOfCis: Int,
                              numberOfUsers: Int,
                              numberOfPlugins: Int,
                              numberOfSubFolders: Int,
                              listOfCiMetrics: List[CiMetrics]) {
    override def toString: String =
      s"FolderPath [$folderPath] NumberOfCis [$numberOfCis] numberOfUsers [$numberOfUsers] numberOfPlugins " +
        s"[$numberOfPlugins] numberOfSubFolders [$numberOfSubFolders] listOfCiMetrics[$listOfCiMetrics] "
  }

  case class DefaultDeploymentMetrics(folderPath: String,
                                      numberOfDeployments: Int,
                                      numberOfUsers: Int,
                                      numberOfPlugins: Int,
                                      listOfDeploymentMetrics: List[DeploymentMetrics]) {
    override def toString: String =
      s"FolderPath [$folderPath] numberOfDeployments [$numberOfDeployments] numberOfUsers [$numberOfUsers] numberOfPlugins " +
        s"[$numberOfPlugins] listOfDeploymentMetrics [$listOfDeploymentMetrics]"}

}

