package ai.digital.deploy.metrics.json

import ai.digital.deploy.metrics.model.CiPluginMetrics
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{Collection => JCollection}
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider
import scala.jdk.CollectionConverters._

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ListConfigurationItemsJsonWriter extends AbstractJsonWriter[JCollection[CiPluginMetrics]] {

  private val matcher = new TypeMatcher(classOf[JCollection[_]], classOf[CiPluginMetrics])
  private val jsonWriterUtil = new JsonWriterUtil

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(ciPluginMetrics: JCollection[CiPluginMetrics], typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(ciPluginMetrics).getBytes)


  override protected def writeJson(lines: JCollection[CiPluginMetrics], writer: JsonWriter): Unit = {
    writer.array
    lines.forEach { line =>
      writer.`object`()
      writer.key("id").value(line.id)
      writer.key("name").value(line.name)
      writer.key("ciType").value(line.ciType)
      writer.key("path").value(line.path)
      writer.key("createdBy").value(line.createdBy)
      writer.key("createdAt").value(line.createdAt)
      writer.key("modifiedAt").value(line.modifiedAt)
      jsonWriterUtil.writePluginsJson(line.plugins.asJava, writer)
      writer.endObject()
    }
    writer.endArray
  }
}
