package ai.digital.deploy.metrics.json

import ai.digital.deploy.metrics.model.FoldersCount
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{Collection => JCollection}
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class SubFoldersCountByCiJsonWriter extends AbstractJsonWriter[JCollection[FoldersCount]] {

  private val matcher = new TypeMatcher(classOf[JCollection[_]], classOf[FoldersCount])

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(foldersCount: JCollection[FoldersCount], typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(foldersCount).getBytes)


  override protected def writeJson(lines: JCollection[FoldersCount], writer: JsonWriter): Unit = {
    writer.array
    lines.forEach { line =>
      writer.`object`()
      writer.key("path").value(line.path)
      writer.key("foldersCount").value(line.foldersCount)
      writer.endObject()
    }
    writer.endArray
  }
}
