/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.task.MigrationStatus;
import com.xebialabs.deployit.task.archive.ArchivedPhase;
import com.xebialabs.deployit.task.archive.ArchivedPhaseContainer;
import com.xebialabs.deployit.task.archive.ArchivedStepBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class ArchivedTask
implements TaskWithSteps,
TaskWithBlock {
    public static final String APP_ENV_KEY_SEPARATOR = "_";
    protected List<StepState> lazySteps = null;
    private int lazyNrSteps = -1;
    private TaskExecutionState state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private Map<String, String> metadata = Maps.newHashMap();
    private int failureCount;
    private String owner;
    private MigrationStatus migrationStatus;
    private BlockState block;
    private List<String> activeBlocks = Lists.newArrayList();
    private DateTime scheduledDate;
    private List<TaskPackageDependency> packageDependencies = Lists.newArrayList();
    private int workerId;

    public List<StepState> getSteps() {
        return this.lazyGetSteps();
    }

    public StepState getStep(int stepNr) {
        Preconditions.checkArgument((stepNr > 0 && stepNr <= this.getNrSteps() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (int)stepNr);
        return this.lazyGetSteps().get(stepNr - 1);
    }

    public TaskExecutionState getState() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public int getNrSteps() {
        if (this.lazyNrSteps == -1) {
            this.lazyNrSteps = this.lazyGetSteps().size();
        }
        return this.lazyNrSteps;
    }

    @Deprecated
    public int getCurrentStepNr() {
        return 0;
    }

    public List<Integer> getCurrentStepNrs() {
        return Lists.newArrayList((Object[])new Integer[]{0});
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public String getOwner() {
        return this.owner;
    }

    public BlockState getBlock() {
        return this.block;
    }

    public List<String> getActiveBlocks() {
        return this.activeBlocks;
    }

    public Integer getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(int workerId) {
        this.workerId = workerId;
    }

    public void setBlock(BlockState block) {
        this.block = block;
    }

    public void setState(TaskExecutionState state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public MigrationStatus getMigrationStatus() {
        return this.migrationStatus;
    }

    public void setMigrationStatus(MigrationStatus migrationStatus) {
        this.migrationStatus = migrationStatus;
    }

    protected List<StepState> lazyGetSteps() {
        if (this.lazySteps == null) {
            this.lazySteps = this.block == null ? Lists.newArrayList() : this.getStepsFromBlock(this.block);
        }
        return this.lazySteps;
    }

    private List<StepState> getStepsFromBlock(BlockState block) {
        if (block instanceof ArchivedStepBlock) {
            ArchivedStepBlock stepBlock = (ArchivedStepBlock)block;
            return stepBlock.getSteps();
        }
        if (block instanceof CompositeBlockState) {
            CompositeBlockState compBlock = (CompositeBlockState)block;
            ArrayList steps = Lists.newArrayList();
            for (BlockState blockState : compBlock.getBlocks()) {
                steps.addAll(this.getStepsFromBlock(blockState));
            }
            return steps;
        }
        if (block instanceof ArchivedPhase) {
            ArchivedPhase phase = (ArchivedPhase)block;
            return this.getStepsFromBlock(phase.underlyingBlock);
        }
        if (block instanceof ArchivedPhaseContainer) {
            ArchivedPhaseContainer container = (ArchivedPhaseContainer)block;
            ArrayList steps = Lists.newArrayList();
            for (BlockState blockState : container.phases) {
                steps.addAll(this.getStepsFromBlock(blockState));
            }
            return steps;
        }
        return new ArrayList<StepState>();
    }

    public List<TaskPackageDependency> getPackageDependencies() {
        return this.packageDependencies;
    }
}

