package com.xebialabs.deployit.support.report

import ai.digital.deploy.sql.model.Report
import com.xebialabs.deployit.core.api.resteasy.Date
import org.joda.time.DateTime

trait DataStatisticsRepositoryService {
  def timeDbQueryNoHit: Long

  def timeDbQueryHit: Long

  def hostCount: Int
  def satelliteCount: Int
  def workersCount: Int

  def getDeploymentReportForAPeriod(fromDate: Date, endDate: Date): Report

  def archivedControlTaskCount(status: String, begin: DateTime, end: DateTime): Int

  def pendingTaskCount(description: String, includeScheduled: Boolean,
                       isScheduledNull: Boolean, includeQueued: Boolean, isQueuedNull: Boolean): Int

  def activeTaskCount(description: String): Int
  def totalGlobalRoleCount: Int

  def getAllPlaceholdersCount: Int
  def getApplicationsWithMaxPlaceholders(limit: Int): Map[String, Int]
  def getAvgPlaceholdersCount: Int

}
