package com.xebialabs.deployit.support.application

import com.xebialabs.deployit.plugin.api.udm.{DeploymentPackage, Version}
import com.xebialabs.deployit.repository.sql.CiRepository
import com.xebialabs.deployit.service.dependency.DependencyFinder
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

@Service
class DependencySupportReportService @Autowired()(dependencySupportReportRepository: DependencySupportReportRepository,
                                                  dependencyFinder: DependencyFinder,
                                                  ciRepository: CiRepository) extends Logging {

  def fetchApplicationsWithDependencies: List[ApplicationWithPackages] = {
    val paths = dependencySupportReportRepository.findDeploymentPackagePathsWithDependencies()
    ciRepository.read[DeploymentPackage](paths, 1, true, false, true).asScala.map {
      version => {
        val dependencies = Try(dependencyFinder.findAndNormalize(version)) match {
          case Success(r) => r
          case Failure(e) =>
            warn("Finding dependencies for report resulted in error - showing as empty versions", e)
            List(List.empty[DeploymentPackage])
        }
        (version, dependencies)
      }
    }.groupMap(_._1.getApplication.getName) {
      case (version: Version, dependencies: List[List[DeploymentPackage]]) =>
        version.getName -> dependencies.flatten.map(_.getId).toSet.size
    }.map {
      case (appName, versionList) => ApplicationWithPackages(appName, versionList.map {
        case (name, size) => PackageWithDependencySize(name, size)
      }.toSet)
    }.toList
  }
}

case class PackageWithDependencySize(name: String, numberOfDependencies: Int)

case class ApplicationWithPackages(name: String, packages: Set[PackageWithDependencySize])
