package com.xebialabs.deployit.support

import com.xebialabs.deployit.repository.sql.base.CiPKType

package report {

  import com.xebialabs.deployit.plugin.api.reflect.Descriptor
  import com.xebialabs.deployit.provision.JList

  import scala.math.BigDecimal.RoundingMode

  case class TopTaskData(taskId: String,
                         durationMillis: Long)

  case class TopNDeployedApplicationData(amountOfDeployeds: Int,
                                         deployedApplication: CiPKType,
                                         deployedApplicationId: String,
                                         environment: CiPKType,
                                         environmentId: String)

  case class ScanPlaceholdersArtifacts(number: Int = 0, sizeOfBytes: Long = 0L) {
    def newSize(size: Long): ScanPlaceholdersArtifacts = ScanPlaceholdersArtifacts(number + 1, sizeOfBytes + size)
  }

  case class Artifacts(scanPlaceholdersOn: ScanPlaceholdersArtifacts = ScanPlaceholdersArtifacts(),
                       scanPlaceholdersOff: ScanPlaceholdersArtifacts = ScanPlaceholdersArtifacts(),
                       numberNotFoundArtifacts: Int = 0,
                       numberOfResolvedPlaceholders: Int = 0,
                       numberArtifactsErrors: Int = 0)

  case class TopTask(durationMillis: Long,
                     numberOfSteps: Int,
                     slowestSteps: Seq[(String, Long)],
                     taskId: String) {
    override def toString: String =
      s"Top task [taskId [$taskId] duration [$durationMillis] millis"
  }

  case class TopNDeployedApplicationsReportLine(amountOfDeployeds: Int,
                                                amountOfResolvedPlaceholders: Int,
                                                artifacts: Artifacts,
                                                topTasks: Seq[TopTask],
                                                orchestrators: Seq[String],
                                                optimizePlan: Boolean,
                                                deployedApplicationId: String,
                                                environmentId: String) {
    override def toString: String =
      s"Deployed application [$deployedApplicationId] environment [$environmentId] amountOfDeployeds [$amountOfDeployeds] topTasks [$topTasks]"
  }

  case class TypeSystemDescriptorsDetails(numberOfTypes: Int, types: JList[Descriptor])

  object report {
    val SYSTEM_INFORMATION_REPORT_TEMPLATE = "system-information-report-template.mustache"
    val SYSTEM_INFORMATION_REPORT_FILE_NAME = "deploy-system-information.html"
    def avg(count: Int, per: Int): Float = if (per > 0) (BigDecimal(count) / BigDecimal(per)).setScale(2, RoundingMode.HALF_UP).floatValue else 0F
  }

}
