package com.xebialabs.deployit.support.rest

import com.xebialabs.deployit.support.report.report._
import com.xebialabs.xlplatform.support.report.ReportDataProvider
import com.xebialabs.xlplatform.support.report.SupportPackageFileWriter.writeToFile
import com.xebialabs.xlplatform.support.report.render.Templater.processTemplate
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.Date
import scala.jdk.CollectionConverters._

@Service
class SystemInformationService @Autowired()(val providers: java.util.List[ReportDataProvider]) extends Logging {

  def writeSystemInformationReport(): Unit = {
    //write system information report to file in log directory
    writeToFile(s"log/$SYSTEM_INFORMATION_REPORT_FILE_NAME", generateHtmlReport(Seq.empty))
  }

  def generateHtmlReport(reports: Seq[String]): String = {
    processTemplate(SYSTEM_INFORMATION_REPORT_TEMPLATE, createReportContext(reports).asJava)
  }

  def generateJsonReport(reports: Seq[String]): java.util.Map[String, Any] = {
    createReportContext(reports).asJava
  }

  protected def createReportContext(reports: Seq[String]): Map[String, Any] = {
    val applicableProviders = providers.asScala
      .filter(provider => reports.isEmpty || reports.contains(provider.name))
    applicableProviders.foldLeft(baseContext)((context, provider) => context ++ provider.collectStatistics)
  }

  protected def baseContext: Map[String, Any] = {
    Map[String, Any]("generatedAt" -> new Date().toString)
  }

}
