package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.support.application.ApplicationWithPackages
import com.xebialabs.xltype.serialization.json.JsonWriter
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ApplicationWithPackagesLineJsonWriter extends AbstractJsonWriter[ApplicationWithPackages] {

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    ApplicationWithPackages.getClass.isAssignableFrom(typeClass)

  override def writeTo(line: ApplicationWithPackages, typeClass: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(line).getBytes)


  override protected[json] def writeJson(app: ApplicationWithPackages, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("applicationName").value(app.name)
    writer.key("packages").array()
    app.packages.foreach { version =>
      writer.`object`()
      writer.key("version").value(version.name)
      writer.key("dependencySize").value(version.numberOfDependencies)
      writer.endObject()
    }
    writer.endArray()
    writer.endObject()
  }
}
