package com.xebialabs.deployit.support.application.sql

import com.xebialabs.deployit.core.sql.spring.Setter
import com.xebialabs.deployit.core.sql.{SqlCondition => cond, _}
import com.xebialabs.deployit.sql.base.schema.CI_PROPERTIES
import com.xebialabs.deployit.sql.base.schema.CIS
import com.xebialabs.deployit.support.application.DependencySupportReportRepository
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.{JdbcTemplate, SingleColumnRowMapper}
import org.springframework.stereotype.Repository
import org.springframework.transaction.annotation.Transactional

import java.util.{List => JList}

@Repository
@Transactional(transactionManager = "mainTransactionManager")
class SqlDependencySupportReportRepository(@Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate)
                                     (@Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo) extends DependencySupportReportRepository {

  @Transactional(transactionManager = "mainTransactionManager", readOnly = true)
  override def findDeploymentPackagePathsWithDependencies(): JList[String] = {

    val deploymentPackageAlias = "package"
    val propertiesAlias = "props"
    val selectBuilder = new SelectBuilder(CIS.tableName).as(deploymentPackageAlias)
      .select(CIS.path)
      .where(
        cond.or(Seq(
          cond.equals(CIS.ci_type.tableAlias(deploymentPackageAlias), "udm.DeploymentPackage"),
          cond.equals(CIS.ci_type.tableAlias(deploymentPackageAlias), "udm.ProvisioningPackage"))
        )
      )
    val queryBuilder = new JoinBuilder(selectBuilder).join(
      new SelectBuilder(CI_PROPERTIES.tableName).as(propertiesAlias)
        .where(cond.equals(CI_PROPERTIES.name.tableAlias(propertiesAlias), "applicationDependencies")),
        cond.equals(CIS.ID.tableAlias(deploymentPackageAlias), CI_PROPERTIES.ci_id.tableAlias(propertiesAlias)),
      JoinType.Inner
    )
    jdbcTemplate.query(queryBuilder.query, Setter(queryBuilder.parameters), new SingleColumnRowMapper[String]())

  }
}

