package com.xebialabs.deployit.support.rest

import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlplatform.support.api.SupportService
import com.xebialabs.xlplatform.support.rest.{SupportAcceleratorConfiguration, SupportResource}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import jakarta.ws.rs._
import jakarta.ws.rs.core._
import scala.util.Try

@Controller
@Path("/support")
class XldSupportResource @Autowired()(supportService: SupportService,
                                      systemInformationService: SystemInformationService,
                                      supportAcceleratorConfiguration: SupportAcceleratorConfiguration)
  extends SupportResource(supportService, supportAcceleratorConfiguration) with Logging {

  override def generateSupportZip(): Response = {
    checkPermission(ADMIN)

    Try(systemInformationService.writeSystemInformationReport())
      .recover { case exception => logger.warn("Unable to generate system information report due to error", exception) }

    super.generateSupportZip()
  }

  @GET
  @Path("/system-information")
  @Produces(Array(MediaType.APPLICATION_JSON, MediaType.TEXT_HTML))
  def getSystemInformation(@QueryParam("reports") reports: String, @Context request: Request): Response = {
    checkPermission(ADMIN)

    val requestedReports = if (reports != null) reports.toLowerCase.split(",").toSeq else Seq.empty
    if (acceptsJson(request)) {
      Response.ok(systemInformationService.generateJsonReport(requestedReports), MediaType.APPLICATION_JSON).build
    } else {
      Response.ok(systemInformationService.generateHtmlReport(requestedReports), MediaType.TEXT_HTML).build
    }
  }

  def acceptsJson(request: Request): Boolean = {
    val variants = Variant.mediaTypes(MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE).build()
    val variant = request.selectVariant(variants)
    variant != null && variant.getMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)
  }
}
