/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.support.report;

import ai.digital.deploy.metrics.model.CiCount;
import ai.digital.deploy.metrics.repository.CiMetricsRepository;
import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.api.TaskMonitorService;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepository;
import com.xebialabs.deployit.security.service.UserStatsService;
import com.xebialabs.deployit.support.report.CiStatistics;
import com.xebialabs.deployit.support.report.ControlTaskStatistics;
import com.xebialabs.deployit.support.report.DataStatisticsRepositoryService;
import com.xebialabs.deployit.support.report.DeploymentStatistics;
import com.xebialabs.deployit.support.report.FolderStatistics;
import com.xebialabs.deployit.support.report.PlaceholderStatistics;
import com.xebialabs.deployit.support.report.PluginStatistics;
import com.xebialabs.deployit.support.report.PluginStatisticsRepository;
import com.xebialabs.deployit.support.report.UserAndRoleStatistics;
import com.xebialabs.deployit.support.report.report$;
import com.xebialabs.xlplatform.support.report.ReportDataProvider;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005m!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003>\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tC\u0002\u0011)\u0019!C\u0001E\"A1\u000e\u0001B\u0001B\u0003%1\r\u0003\u0005m\u0001\t\u0015\r\u0011\"\u0001n\u0011!\t\bA!A!\u0002\u0013q\u0007\"\u0002:\u0001\t\u0003\u0019\b\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0011!\ty\u0003\u0001Q\u0001\n\u0005e\u0001bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0005Y!\u0015\r^1Ti\u0006$\u0018n\u001d;jGN\u0004&o\u001c<jI\u0016\u0014(BA\u000e\u001d\u0003\u0019\u0011X\r]8si*\u0011QDH\u0001\bgV\u0004\bo\u001c:u\u0015\ty\u0002%\u0001\u0005eKBdw._5u\u0015\t\t#%A\u0005yK\nL\u0017\r\\1cg*\t1%A\u0002d_6\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u00173\u001b\u0005q#BA\u000e0\u0015\ti\u0002G\u0003\u00022A\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u0005Mr#A\u0005*fa>\u0014H\u000fR1uCB\u0013xN^5eKJ\f\u0001\u0004Z1uCN#\u0018\r^5ti&\u001c7OU3q_NLGo\u001c:z+\u00051\u0004CA\u001c9\u001b\u0005Q\u0012BA\u001d\u001b\u0005}!\u0015\r^1Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/_*feZL7-Z\u0001\u001aI\u0006$\u0018m\u0015;bi&\u001cH/[2t%\u0016\u0004xn]5u_JL\b%A\ndS6+GO]5dgJ+\u0007o\\:ji>\u0014\u00180F\u0001>!\tq\u0014*D\u0001@\u0015\t\u0001\u0015)\u0001\u0006sKB|7/\u001b;pefT!AQ\"\u0002\u000f5,GO]5dg*\u0011A)R\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u0019;\u0015a\u00023jO&$\u0018\r\u001c\u0006\u0002\u0011\u0006\u0011\u0011-[\u0005\u0003\u0015~\u00121cQ5NKR\u0014\u0018nY:SKB|7/\u001b;pef\fAcY5NKR\u0014\u0018nY:SKB|7/\u001b;pef\u0004\u0013!\u00069mC\u000e,\u0007n\u001c7eKJ\u0014V\r]8tSR|'/_\u000b\u0002\u001dB\u0011qjU\u0007\u0002!*\u0011\u0011KU\u0001\ra2\f7-\u001a5pY\u0012,'o\u001d\u0006\u0003\u0001zI!\u0001\u0016)\u0003+Ac\u0017mY3i_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\u00061\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\b%\u0001\nuCN\\Wj\u001c8ji>\u00148+\u001a:wS\u000e,W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016aA1qS*\u0011QLH\u0001\u0005G>\u0014X-\u0003\u0002`5\n\u0011B+Y:l\u001b>t\u0017\u000e^8s'\u0016\u0014h/[2f\u0003M!\u0018m]6N_:LGo\u001c:TKJ4\u0018nY3!\u0003A)8/\u001a:Ti\u0006$8oU3sm&\u001cW-F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-A\u0004tKJ4\u0018nY3\u000b\u0005!t\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005),'\u0001E+tKJ\u001cF/\u0019;t'\u0016\u0014h/[2f\u0003E)8/\u001a:Ti\u0006$8oU3sm&\u001cW\rI\u0001\u001ba2,x-\u001b8Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/_\u000b\u0002]B\u0011qg\\\u0005\u0003aj\u0011!\u0004\u00157vO&t7\u000b^1uSN$\u0018nY:SKB|7/\u001b;pef\f1\u0004\u001d7vO&t7\u000b^1uSN$\u0018nY:SKB|7/\u001b;pef\u0004\u0013A\u0002\u001fj]&$h\bF\u0004ukZ<\b0\u001f>\u0011\u0005]\u0002\u0001\"\u0002\u001b\u000e\u0001\u00041\u0004\"B\u001e\u000e\u0001\u0004i\u0004\"\u0002'\u000e\u0001\u0004q\u0005\"\u0002,\u000e\u0001\u0004A\u0006\"B1\u000e\u0001\u0004\u0019\u0007\"\u00027\u000e\u0001\u0004q\u0007FA\u0007}!\ri\u0018\u0011C\u0007\u0002}*\u0019q0!\u0001\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u00024bGR|'/\u001f\u0006\u0005\u0003\u000f\tI!A\u0003cK\u0006t7O\u0003\u0003\u0002\f\u00055\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005=\u0011aA8sO&\u0019\u00111\u0003@\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u00028b[\u0016,\"!!\u0007\u0011\t\u0005m\u0011\u0011\u0006\b\u0005\u0003;\t)\u0003E\u0002\u0002 !j!!!\t\u000b\u0007\u0005\rB%\u0001\u0004=e>|GOP\u0005\u0004\u0003OA\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(!\nQA\\1nK\u0002\n\u0011cY8mY\u0016\u001cGo\u0015;bi&\u001cH/[2t+\t\t)\u0004\u0005\u0005\u0002\u001c\u0005]\u0012\u0011DA\u001e\u0013\u0011\tI$!\f\u0003\u00075\u000b\u0007\u000fE\u0002(\u0003{I1!a\u0010)\u0005\r\te._\u0001\u0014G>dG.Z2u\u0007&\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003\u000b\u00022aNA$\u0013\r\tIE\u0007\u0002\r\u0007&\u001cF/\u0019;jgRL7m]\u0001\u001cG>dG.Z2u\t\u0016\u0004Hn\\=nK:$8\u000b^1uSN$\u0018nY:\u0016\u0005\u0005=\u0003cA\u001c\u0002R%\u0019\u00111\u000b\u000e\u0003)\u0011+\u0007\u000f\\8z[\u0016tGo\u0015;bi&\u001cH/[2t\u0003I9W\r\u001e#fa2|\u00170\\3oi\u000e{WO\u001c;\u0015\r\u0005e\u0013qLA9!\r9\u00131L\u0005\u0004\u0003;B#aA%oi\"11d\u0005a\u0001\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0003n_\u0012,GNC\u0002\u0002l\r\u000b1a]9m\u0013\u0011\ty'!\u001a\u0003\rI+\u0007o\u001c:u\u0011\u001d\t\u0019h\u0005a\u0001\u00033\ta\u0002Z3qY>LX.\u001a8u)f\u0004X-A\fd_2dWm\u0019;G_2$WM]*uCRL7\u000f^5dgV\u0011\u0011\u0011\u0010\t\u0004o\u0005m\u0014bAA?5\t\u0001bi\u001c7eKJ\u001cF/\u0019;jgRL7m]\u0001\"G>dG.Z2u\u0007>tGO]8m)\u0006\u001c8.V:bO\u0016\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003\u0007\u00032aNAC\u0013\r\t9I\u0007\u0002\u0016\u0007>tGO]8m)\u0006\u001c8n\u0015;bi&\u001cH/[2t\u0003u\u0019w\u000e\u001c7fGR,6/\u001a:t\u0003:$'k\u001c7f'R\fG/[:uS\u000e\u001cXCAAG!\r9\u0014qR\u0005\u0004\u0003#S\"!F+tKJ\fe\u000e\u001a*pY\u0016\u001cF/\u0019;jgRL7m]\u0001\u001dG>dG.Z2u!2\f7-\u001a5pY\u0012,'o\u0015;bi&\u001cH/[2t+\t\t9\nE\u00028\u00033K1!a'\u001b\u0005U\u0001F.Y2fQ>dG-\u001a:Ti\u0006$\u0018n\u001d;jGN\f\u0001dY8mY\u0016\u001cG\u000f\u00157vO&t7o\u0015;bi&\u001cH/[2t+\t\t\t\u000bE\u00028\u0003GK1!!*\u001b\u0005A\u0001F.^4j]N#\u0018\r^5ti&\u001c7\u000fK\u0002\u0001\u0003S\u0003B!a+\u000226\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000bI!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a-\u0002.\nI1i\\7q_:,g\u000e\u001e")
public class DataStatisticsProvider
implements ReportDataProvider {
    private final DataStatisticsRepositoryService dataStatisticsRepository;
    private final CiMetricsRepository ciMetricsRepository;
    private final PlaceholderRepository placeholderRepository;
    private final TaskMonitorService taskMonitorService;
    private final UserStatsService userStatsService;
    private final PluginStatisticsRepository pluginStatisticsRepository;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DataStatisticsProvider dataStatisticsProvider = this;
        synchronized (dataStatisticsProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public DataStatisticsRepositoryService dataStatisticsRepository() {
        return this.dataStatisticsRepository;
    }

    public CiMetricsRepository ciMetricsRepository() {
        return this.ciMetricsRepository;
    }

    public PlaceholderRepository placeholderRepository() {
        return this.placeholderRepository;
    }

    public TaskMonitorService taskMonitorService() {
        return this.taskMonitorService;
    }

    public UserStatsService userStatsService() {
        return this.userStatsService;
    }

    public PluginStatisticsRepository pluginStatisticsRepository() {
        return this.pluginStatisticsRepository;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> collectStatistics() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ci"), (Object)this.collectCiStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployments"), (Object)this.collectDeploymentStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks"), (Object)this.collectControlTaskUsageStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folders"), (Object)this.collectFolderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)this.collectUsersAndRoleStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"placeholders"), (Object)this.collectPlaceholderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugins"), (Object)this.collectPluginsStatistics())}))).asJava())}));
    }

    public CiStatistics collectCiStatistics() {
        CiStatistics statistics = new CiStatistics();
        CiCount applicationCount = this.ciMetricsRepository().getCisCount((List)new .colon.colon((Object)"udm.Application", (List)Nil$.MODULE$), (Option)new Some((Object)"/Applications"), null, null, null);
        statistics.totalApplication_$eq((int)applicationCount.ciCount());
        statistics.totalHosts_$eq(this.dataStatisticsRepository().hostCount());
        statistics.totalSatellites_$eq(this.dataStatisticsRepository().satelliteCount());
        statistics.totalWorker_$eq(this.dataStatisticsRepository().workersCount());
        return statistics;
    }

    public DeploymentStatistics collectDeploymentStatistics() {
        DeploymentStatistics statistics = new DeploymentStatistics();
        Date fromDate = new Date(DateTime.now().minusDays(30).toDate().toString());
        Date toDate = new Date(DateTime.now().toDate().toString());
        Date from24hrs = new Date(DateTime.now().minusHours(24).toDate().toString());
        Report reportFor24hrs = this.dataStatisticsRepository().getDeploymentReportForAPeriod(from24hrs, toDate);
        statistics.successfulDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "successful"));
        statistics.rollbackDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "rollback"));
        statistics.abortedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "aborted"));
        statistics.retriedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "failed"));
        statistics.totalDeploymentFor24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "totalDeployment"));
        Report reportFor30days = this.dataStatisticsRepository().getDeploymentReportForAPeriod(fromDate, toDate);
        statistics.totalDeploymentFor30days_$eq(this.getDeploymentCount(reportFor30days, "totalDeployment"));
        statistics.averageDeploymentPerDayPerMonth_$eq(report$.MODULE$.avg(statistics.totalDeploymentFor30days(), 30));
        Date forAYear = new Date(DateTime.now().minusDays(365).toDate().toString());
        Report reportForAYear = this.dataStatisticsRepository().getDeploymentReportForAPeriod(forAYear, toDate);
        int totalDeploymentForYr = this.getDeploymentCount(reportForAYear, "totalDeployment");
        statistics.averageDeploymentPerDayPerYr_$eq(report$.MODULE$.avg(totalDeploymentForYr, 365));
        statistics.totalDeploymentsInLastYear_$eq(totalDeploymentForYr);
        statistics.successfulDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "successful"));
        statistics.rollbackDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "rollback"));
        statistics.abortedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "aborted"));
        statistics.retriedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "failed"));
        statistics.totalPendingDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, true, true, true));
        statistics.totalScheduledDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, false, false, false));
        statistics.totalQueuedDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", false, false, true, false));
        statistics.activeDeployments_$eq(this.dataStatisticsRepository().activeTaskCount("deployment"));
        return statistics;
    }

    public int getDeploymentCount(Report report2, String deploymentType) {
        int successful = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfSuccessfulDeployments").toString()));
        int rollBack = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfRollbacks").toString()));
        int failed = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfFailedDeployments").toString()));
        int aborted = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfAbortedDeployments").toString()));
        int totalDeployment = successful + rollBack + failed + aborted;
        String string = deploymentType;
        switch (string == null ? 0 : string.hashCode()) {
            case -1281977283: {
                if (!"failed".equals(string)) break;
                return failed;
            }
            case -1194777649: {
                if (!"aborted".equals(string)) break;
                return aborted;
            }
            case -733631846: {
                if (!"successful".equals(string)) break;
                return successful;
            }
            case -259719452: {
                if (!"rollback".equals(string)) break;
                return rollBack;
            }
            case 1596796201: {
                if (!"totalDeployment".equals(string)) break;
                return totalDeployment;
            }
        }
        throw new MatchError((Object)string);
    }

    public FolderStatistics collectFolderStatistics() {
        FolderStatistics statistics = new FolderStatistics();
        statistics.applicationFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Applications")).foldersCount());
        statistics.environmentFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Environments")).foldersCount());
        statistics.infraFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Infrastructure")).foldersCount());
        return statistics;
    }

    public ControlTaskStatistics collectControlTaskUsageStatistics() {
        ControlTaskStatistics controlTaskStatistics = new ControlTaskStatistics();
        int totalTasksFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalTaskFor24hrs(totalTasksFor24Hours);
        int totalTasksFor30Days = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(30), DateTime.now());
        controlTaskStatistics.setTotalTaskFor30days(totalTasksFor30Days);
        controlTaskStatistics.setAverageTaskPerDayPerMonth(report$.MODULE$.avg(totalTasksFor30Days, 30));
        int totalTasksPerYear = this.dataStatisticsRepository().archivedControlTaskCount("ALL", DateTime.now().minusDays(365), DateTime.now());
        controlTaskStatistics.setAverageTaskPerDayPerYr(report$.MODULE$.avg(totalTasksPerYear, 365));
        int totalActiveTasks = this.dataStatisticsRepository().activeTaskCount("Control task");
        controlTaskStatistics.setTotalActiveTasks(totalActiveTasks);
        int pendingCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, true, true, true);
        controlTaskStatistics.setTotalPendingTasks(pendingCount);
        int scheduledCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, false, false, false);
        controlTaskStatistics.setTotalScheduledTasks(scheduledCount);
        int queuedCount = this.dataStatisticsRepository().pendingTaskCount("Control task", false, false, true, false);
        controlTaskStatistics.setTotalQueuedTasks(queuedCount);
        int completedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.DONE.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalSuccessfulTasksIn24Hours(completedCountFor24Hours);
        int abortedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.CANCELLED.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalAbortedTasksIn24Hours(abortedCountFor24Hours);
        return controlTaskStatistics;
    }

    public UserAndRoleStatistics collectUsersAndRoleStatistics() {
        UserAndRoleStatistics statistics = new UserAndRoleStatistics();
        statistics.totalActiveUsers_$eq(this.dataStatisticsRepository().countNumberOfInternalUsers());
        statistics.totalGlobalRoles_$eq(this.dataStatisticsRepository().totalGlobalRoleCount());
        Map userStatsByProfile = this.userStatsService().prepareUserStatsByUserProfile();
        statistics.numberOfUsers_$eq(BoxesRunTime.unboxToInt((Object)userStatsByProfile.apply((Object)"allUsers")));
        statistics.numberOfLicensedUsers_$eq(BoxesRunTime.unboxToInt((Object)userStatsByProfile.apply((Object)"usersEnabled")));
        statistics.numberOfLicensedExternalUsers_$eq(BoxesRunTime.unboxToInt((Object)userStatsByProfile.apply((Object)"usersEnabledWithExternal")));
        statistics.numberOfLicensedInternalUsers_$eq(BoxesRunTime.unboxToInt((Object)userStatsByProfile.apply((Object)"usersEnabledWithInternal")));
        return statistics;
    }

    public PlaceholderStatistics collectPlaceholderStatistics() {
        PlaceholderStatistics statistics = new PlaceholderStatistics();
        statistics.placeholdersCount_$eq(this.dataStatisticsRepository().getAllPlaceholdersCount());
        statistics.avgPlaceholdersCountByDeployedApp_$eq(this.dataStatisticsRepository().getAvgPlaceholdersCount());
        statistics.appWithMaxPlaceholders_$eq(((IterableOnceOps)this.dataStatisticsRepository().getApplicationsWithMaxPlaceholders(5).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return k + " - " + Integer.toString(v);
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n"));
        return statistics;
    }

    public PluginStatistics collectPluginsStatistics() {
        PluginStatistics statistics = new PluginStatistics();
        statistics.pluginsDataByDeployment_$eq(this.pluginStatisticsRepository().getPluginDataByDeploymentByDuration(DateTime.now().minusDays(180), DateTime.now()));
        return statistics;
    }

    @Autowired
    public DataStatisticsProvider(DataStatisticsRepositoryService dataStatisticsRepository, CiMetricsRepository ciMetricsRepository, PlaceholderRepository placeholderRepository, TaskMonitorService taskMonitorService, UserStatsService userStatsService, PluginStatisticsRepository pluginStatisticsRepository) {
        this.dataStatisticsRepository = dataStatisticsRepository;
        this.ciMetricsRepository = ciMetricsRepository;
        this.placeholderRepository = placeholderRepository;
        this.taskMonitorService = taskMonitorService;
        this.userStatsService = userStatsService;
        this.pluginStatisticsRepository = pluginStatisticsRepository;
        Logging.$init$((Logging)this);
        this.name = "data";
    }
}

