package com.xebialabs.deployit.support.report

import ai.digital.deploy.sql.model.Report
import com.xebialabs.deployit.core.api.resteasy.Date
import org.joda.time.DateTime

trait DataStatisticsRepositoryService {
  def timeDbQueryNoHit: Long

  def timeDbQueryHit: Long

  def hostCount: Int
  def satelliteCount: Int
  def workersCount: Int

  def getDeploymentReportForAPeriod(fromDate: Date, endDate: Date): Report

  def archivedControlTaskCount(status: String, begin: DateTime, end: DateTime): Int

  def pendingTaskCount(description: String, includeScheduled: Boolean,
                       isScheduledNull: Boolean, includeQueued: Boolean, isQueuedNull: Boolean): Int

  def activeTaskCount(description: String): Int

  @Deprecated // refer to the UserStatsService.prepareUserStatsByUserProfile.allUsers instead
  /*
      FIXME - deprecated totalActiveUsersCount need to read it from UserStatsService.prepareUserStatsByUserProfile["allUsers"]
      instead it is reading DataStatisticsRepositoryService.countNumberOfInternalUsers for now because of pendo event dependency
   */
  def totalActiveUsersCount: Int
  /*
    new method added for count total number of users irrespective of user profile of login enabled/disabled internal/external
  */
  def countNumberOfInternalUsers : Int
  def totalGlobalRoleCount: Int

  def getAllPlaceholdersCount: Int
  def getApplicationsWithMaxPlaceholders(limit: Int): Map[String, Int]
  def getAvgPlaceholdersCount: Int

}
