/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.support.report;

import ai.digital.deploy.metrics.model.CiCount;
import ai.digital.deploy.metrics.repository.CiMetricsRepository;
import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.api.TaskMonitorService;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepository;
import com.xebialabs.deployit.support.report.CiStatistics;
import com.xebialabs.deployit.support.report.ControlTaskStatistics;
import com.xebialabs.deployit.support.report.DataStatisticsRepositoryService;
import com.xebialabs.deployit.support.report.DeploymentStatistics;
import com.xebialabs.deployit.support.report.FolderStatistics;
import com.xebialabs.deployit.support.report.PlaceholderStatistics;
import com.xebialabs.deployit.support.report.PluginStatistics;
import com.xebialabs.deployit.support.report.PluginStatisticsRepository;
import com.xebialabs.deployit.support.report.UserAndRoleStatistics;
import com.xebialabs.deployit.support.report.report$;
import com.xebialabs.xlplatform.support.report.ReportDataProvider;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001B\f\u0019\u0001\rB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tq\u0001\u0011\t\u0011)A\u0005i!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003<\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t?\u0002\u0011)\u0019!C\u0001A\"AA\r\u0001B\u0001B\u0003%\u0011\rC\u0003f\u0001\u0011\u0005a\rC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005M\u0001\u0001)A\u0005}\"9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0002\u0017\t\u0006$\u0018m\u0015;bi&\u001cH/[2t!J|g/\u001b3fe*\u0011\u0011DG\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005ma\u0012aB:vaB|'\u000f\u001e\u0006\u0003;y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003?\u0001\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0005\n1aY8n\u0007\u0001\u00192\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111\u0006M\u0007\u0002Y)\u0011\u0011$\f\u0006\u000379R!a\f\u0010\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u00022Y\t\u0011\"+\u001a9peR$\u0015\r^1Qe>4\u0018\u000eZ3s\u0003a!\u0017\r^1Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/_\u000b\u0002iA\u0011QGN\u0007\u00021%\u0011q\u0007\u0007\u0002 \t\u0006$\u0018m\u0015;bi&\u001cH/[2t%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017!\u00073bi\u0006\u001cF/\u0019;jgRL7m\u001d*fa>\u001c\u0018\u000e^8ss\u0002\n1cY5NKR\u0014\u0018nY:SKB|7/\u001b;pef,\u0012a\u000f\t\u0003y\u001dk\u0011!\u0010\u0006\u0003}}\n!B]3q_NLGo\u001c:z\u0015\t\u0001\u0015)A\u0004nKR\u0014\u0018nY:\u000b\u0005\t\u001b\u0015A\u00023fa2|\u0017P\u0003\u0002E\u000b\u00069A-[4ji\u0006d'\"\u0001$\u0002\u0005\u0005L\u0017B\u0001%>\u0005M\u0019\u0015.T3ue&\u001c7OU3q_NLGo\u001c:z\u0003Q\u0019\u0017.T3ue&\u001c7OU3q_NLGo\u001c:zA\u0005)\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JLX#\u0001'\u0011\u00055\u000bV\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u00049mC\u000e,\u0007n\u001c7eKJ\u001c(B\u0001 \u001d\u0013\t\u0011fJA\u000bQY\u0006\u001cW\r[8mI\u0016\u0014(+\u001a9pg&$xN]=\u0002-Ad\u0017mY3i_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\u0002\n!\u0003^1tW6{g.\u001b;peN+'O^5dKV\ta\u000b\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006\u0019\u0011\r]5\u000b\u0005mc\u0012\u0001B2pe\u0016L!!\u0018-\u0003%Q\u000b7o['p]&$xN]*feZL7-Z\u0001\u0014i\u0006\u001c8.T8oSR|'oU3sm&\u001cW\rI\u0001\u001ba2,x-\u001b8Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/_\u000b\u0002CB\u0011QGY\u0005\u0003Gb\u0011!\u0004\u00157vO&t7\u000b^1uSN$\u0018nY:SKB|7/\u001b;pef\f1\u0004\u001d7vO&t7\u000b^1uSN$\u0018nY:SKB|7/\u001b;pef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004hQ&T7\u000e\u001c\t\u0003k\u0001AQAM\u0006A\u0002QBQ!O\u0006A\u0002mBQAS\u0006A\u00021CQ\u0001V\u0006A\u0002YCQaX\u0006A\u0002\u0005D#a\u00038\u0011\u0005=TX\"\u00019\u000b\u0005E\u0014\u0018AC1o]>$\u0018\r^5p]*\u00111\u000f^\u0001\bM\u0006\u001cGo\u001c:z\u0015\t)h/A\u0003cK\u0006t7O\u0003\u0002xq\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001z\u0003\ry'oZ\u0005\u0003wB\u0014\u0011\"Q;u_^L'/\u001a3\u0002\t9\fW.Z\u000b\u0002}B\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u00071SBAA\u0003\u0015\r\t9AI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-a%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u00171\u0013!\u00028b[\u0016\u0004\u0013!E2pY2,7\r^*uCRL7\u000f^5dgV\u0011\u0011\u0011\u0004\t\u0007\u007f\u0006ma0a\b\n\t\u0005u\u0011\u0011\u0003\u0002\u0004\u001b\u0006\u0004\bcA\u0013\u0002\"%\u0019\u00111\u0005\u0014\u0003\u0007\u0005s\u00170A\nd_2dWm\u0019;DSN#\u0018\r^5ti&\u001c7/\u0006\u0002\u0002*A\u0019Q'a\u000b\n\u0007\u00055\u0002D\u0001\u0007DSN#\u0018\r^5ti&\u001c7/A\u000ed_2dWm\u0019;EKBdw._7f]R\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003g\u00012!NA\u001b\u0013\r\t9\u0004\u0007\u0002\u0015\t\u0016\u0004Hn\\=nK:$8\u000b^1uSN$\u0018nY:\u0002%\u001d,G\u000fR3qY>LX.\u001a8u\u0007>,h\u000e\u001e\u000b\u0007\u0003{\t\u0019%!\u0016\u0011\u0007\u0015\ny$C\u0002\u0002B\u0019\u00121!\u00138u\u0011\u0019I\u0012\u00031\u0001\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!B7pI\u0016d'bAA(\u0003\u0006\u00191/\u001d7\n\t\u0005M\u0013\u0011\n\u0002\u0007%\u0016\u0004xN\u001d;\t\r\u0005]\u0013\u00031\u0001\u007f\u00039!W\r\u001d7ps6,g\u000e\u001e+za\u0016\fqcY8mY\u0016\u001cGOR8mI\u0016\u00148\u000b^1uSN$\u0018nY:\u0016\u0005\u0005u\u0003cA\u001b\u0002`%\u0019\u0011\u0011\r\r\u0003!\u0019{G\u000eZ3s'R\fG/[:uS\u000e\u001c\u0018!I2pY2,7\r^\"p]R\u0014x\u000e\u001c+bg.,6/Y4f'R\fG/[:uS\u000e\u001cXCAA4!\r)\u0014\u0011N\u0005\u0004\u0003WB\"!F\"p]R\u0014x\u000e\u001c+bg.\u001cF/\u0019;jgRL7m]\u0001\u001eG>dG.Z2u+N,'o]!oIJ{G.Z*uCRL7\u000f^5dgV\u0011\u0011\u0011\u000f\t\u0004k\u0005M\u0014bAA;1\t)Rk]3s\u0003:$'k\u001c7f'R\fG/[:uS\u000e\u001c\u0018\u0001H2pY2,7\r\u001e)mC\u000e,\u0007n\u001c7eKJ\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003w\u00022!NA?\u0013\r\ty\b\u0007\u0002\u0016!2\f7-\u001a5pY\u0012,'o\u0015;bi&\u001cH/[2t\u0003a\u0019w\u000e\u001c7fGR\u0004F.^4j]N\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003\u000b\u00032!NAD\u0013\r\tI\t\u0007\u0002\u0011!2,x-\u001b8Ti\u0006$\u0018n\u001d;jGND3\u0001AAG!\u0011\ty)!&\u000e\u0005\u0005E%bAAJm\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005]\u0015\u0011\u0013\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DataStatisticsProvider
implements ReportDataProvider {
    private final DataStatisticsRepositoryService dataStatisticsRepository;
    private final CiMetricsRepository ciMetricsRepository;
    private final PlaceholderRepository placeholderRepository;
    private final TaskMonitorService taskMonitorService;
    private final PluginStatisticsRepository pluginStatisticsRepository;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DataStatisticsProvider dataStatisticsProvider = this;
        synchronized (dataStatisticsProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public DataStatisticsRepositoryService dataStatisticsRepository() {
        return this.dataStatisticsRepository;
    }

    public CiMetricsRepository ciMetricsRepository() {
        return this.ciMetricsRepository;
    }

    public PlaceholderRepository placeholderRepository() {
        return this.placeholderRepository;
    }

    public TaskMonitorService taskMonitorService() {
        return this.taskMonitorService;
    }

    public PluginStatisticsRepository pluginStatisticsRepository() {
        return this.pluginStatisticsRepository;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> collectStatistics() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ci"), (Object)this.collectCiStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployments"), (Object)this.collectDeploymentStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks"), (Object)this.collectControlTaskUsageStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folders"), (Object)this.collectFolderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)this.collectUsersAndRoleStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"placeholders"), (Object)this.collectPlaceholderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugins"), (Object)this.collectPluginsStatistics())}))).asJava())}));
    }

    public CiStatistics collectCiStatistics() {
        CiStatistics statistics = new CiStatistics();
        CiCount applicationCount = this.ciMetricsRepository().getCisCount((List)new .colon.colon((Object)"udm.Application", (List)Nil$.MODULE$), (Option)new Some((Object)"/Applications"), null, null, null);
        statistics.totalApplication_$eq((int)applicationCount.ciCount());
        statistics.totalHosts_$eq(this.dataStatisticsRepository().hostCount());
        statistics.totalSatellites_$eq(this.dataStatisticsRepository().satelliteCount());
        statistics.totalWorker_$eq(this.dataStatisticsRepository().workersCount());
        return statistics;
    }

    public DeploymentStatistics collectDeploymentStatistics() {
        DeploymentStatistics statistics = new DeploymentStatistics();
        Date fromDate = new Date(DateTime.now().minusDays(30).toDate().toString());
        Date toDate = new Date(DateTime.now().toDate().toString());
        Date from24hrs = new Date(DateTime.now().minusHours(24).toDate().toString());
        Report reportFor24hrs = this.dataStatisticsRepository().getDeploymentReportForAPeriod(from24hrs, toDate);
        statistics.successfulDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "successful"));
        statistics.rollbackDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "rollback"));
        statistics.abortedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "aborted"));
        statistics.retriedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "failed"));
        statistics.totalDeploymentFor24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "totalDeployment"));
        Report reportFor30days = this.dataStatisticsRepository().getDeploymentReportForAPeriod(fromDate, toDate);
        statistics.totalDeploymentFor30days_$eq(this.getDeploymentCount(reportFor30days, "totalDeployment"));
        statistics.averageDeploymentPerDayPerMonth_$eq(report$.MODULE$.avg(statistics.totalDeploymentFor30days(), 30));
        Date forAYear = new Date(DateTime.now().minusDays(365).toDate().toString());
        Report reportForAYear = this.dataStatisticsRepository().getDeploymentReportForAPeriod(forAYear, toDate);
        int totalDeploymentForYr = this.getDeploymentCount(reportForAYear, "totalDeployment");
        statistics.averageDeploymentPerDayPerYr_$eq(report$.MODULE$.avg(totalDeploymentForYr, 365));
        statistics.totalDeploymentsInLastYear_$eq(totalDeploymentForYr);
        statistics.successfulDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "successful"));
        statistics.rollbackDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "rollback"));
        statistics.abortedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "aborted"));
        statistics.retriedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "failed"));
        statistics.totalPendingDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, true, true, true));
        statistics.totalScheduledDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, false, false, false));
        statistics.totalQueuedDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", false, false, true, false));
        statistics.activeDeployments_$eq(this.dataStatisticsRepository().activeTaskCount("deployment"));
        return statistics;
    }

    public int getDeploymentCount(Report report2, String deploymentType) {
        int successful = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfSuccessfulDeployments").toString()));
        int rollBack = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfRollbacks").toString()));
        int failed = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfFailedDeployments").toString()));
        int aborted = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfAbortedDeployments").toString()));
        int totalDeployment = successful + rollBack + failed + aborted;
        String string = deploymentType;
        switch (string == null ? 0 : string.hashCode()) {
            case -1281977283: {
                if (!"failed".equals(string)) break;
                return failed;
            }
            case -1194777649: {
                if (!"aborted".equals(string)) break;
                return aborted;
            }
            case -733631846: {
                if (!"successful".equals(string)) break;
                return successful;
            }
            case -259719452: {
                if (!"rollback".equals(string)) break;
                return rollBack;
            }
            case 1596796201: {
                if (!"totalDeployment".equals(string)) break;
                return totalDeployment;
            }
        }
        throw new MatchError((Object)string);
    }

    public FolderStatistics collectFolderStatistics() {
        FolderStatistics statistics = new FolderStatistics();
        statistics.applicationFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Applications")).foldersCount());
        statistics.environmentFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Environments")).foldersCount());
        statistics.infraFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Infrastructure")).foldersCount());
        return statistics;
    }

    public ControlTaskStatistics collectControlTaskUsageStatistics() {
        ControlTaskStatistics controlTaskStatistics = new ControlTaskStatistics();
        int totalTasksFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalTaskFor24hrs(totalTasksFor24Hours);
        int totalTasksFor30Days = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(30), DateTime.now());
        controlTaskStatistics.setTotalTaskFor30days(totalTasksFor30Days);
        controlTaskStatistics.setAverageTaskPerDayPerMonth(report$.MODULE$.avg(totalTasksFor30Days, 30));
        int totalTasksPerYear = this.dataStatisticsRepository().archivedControlTaskCount("ALL", DateTime.now().minusDays(365), DateTime.now());
        controlTaskStatistics.setAverageTaskPerDayPerYr(report$.MODULE$.avg(totalTasksPerYear, 365));
        int totalActiveTasks = this.dataStatisticsRepository().activeTaskCount("Control task");
        controlTaskStatistics.setTotalActiveTasks(totalActiveTasks);
        int pendingCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, true, true, true);
        controlTaskStatistics.setTotalPendingTasks(pendingCount);
        int scheduledCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, false, false, false);
        controlTaskStatistics.setTotalScheduledTasks(scheduledCount);
        int queuedCount = this.dataStatisticsRepository().pendingTaskCount("Control task", false, false, true, false);
        controlTaskStatistics.setTotalQueuedTasks(queuedCount);
        int completedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.DONE.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalSuccessfulTasksIn24Hours(completedCountFor24Hours);
        int abortedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.CANCELLED.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalAbortedTasksIn24Hours(abortedCountFor24Hours);
        return controlTaskStatistics;
    }

    public UserAndRoleStatistics collectUsersAndRoleStatistics() {
        UserAndRoleStatistics statistics = new UserAndRoleStatistics();
        statistics.totalActiveUsers_$eq(this.dataStatisticsRepository().totalActiveUsersCount());
        statistics.totalGlobalRoles_$eq(this.dataStatisticsRepository().totalGlobalRoleCount());
        return statistics;
    }

    public PlaceholderStatistics collectPlaceholderStatistics() {
        PlaceholderStatistics statistics = new PlaceholderStatistics();
        statistics.placeholdersCount_$eq(this.dataStatisticsRepository().getAllPlaceholdersCount());
        statistics.avgPlaceholdersCountByDeployedApp_$eq(this.dataStatisticsRepository().getAvgPlaceholdersCount());
        statistics.appWithMaxPlaceholders_$eq(((IterableOnceOps)this.dataStatisticsRepository().getApplicationsWithMaxPlaceholders(5).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return k + " - " + Integer.toString(v);
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n"));
        return statistics;
    }

    public PluginStatistics collectPluginsStatistics() {
        PluginStatistics statistics = new PluginStatistics();
        statistics.pluginsDataByDeployment_$eq(this.pluginStatisticsRepository().getPluginDataByDeploymentByDuration(DateTime.now().minusDays(180), DateTime.now()));
        return statistics;
    }

    @Autowired
    public DataStatisticsProvider(DataStatisticsRepositoryService dataStatisticsRepository, CiMetricsRepository ciMetricsRepository, PlaceholderRepository placeholderRepository, TaskMonitorService taskMonitorService, PluginStatisticsRepository pluginStatisticsRepository) {
        this.dataStatisticsRepository = dataStatisticsRepository;
        this.ciMetricsRepository = ciMetricsRepository;
        this.placeholderRepository = placeholderRepository;
        this.taskMonitorService = taskMonitorService;
        this.pluginStatisticsRepository = pluginStatisticsRepository;
        Logging.$init$((Logging)this);
        this.name = "data";
    }
}

