package com.xebialabs.deployit.support.report

import com.xebialabs.plugin.manager.service.PluginService
import com.xebialabs.xlplatform.support.report.ReportDataProvider
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.io.File
import java.util
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._
import scala.reflect.io.Directory

@Component
class InstallationDataProvider @Autowired()(val pluginService: PluginService)
  extends ReportDataProvider with Logging {

  val hotfixDir: File = new File("hotfix")
  val name: String = "installation"

  override def collectStatistics: Map[String, Any] = {
    val statistics = new InstallationInfo()
    statistics.setPlugins(pluginService.listInstalled().map(plugin => plugin.filename).toList.asJava)
    statistics.setHotfixes(listHotfixDirectoryFiles(hotfixDir).asJava)
    statistics.setClasspathEntries(serverClassPath.asJava)
    Map[String, Any](name -> statistics)
  }

  def listHotfixDirectoryFiles(file: File): List[String] = {
    val dir = new Directory(file)
    dir.deepList(-1).map(_.toString()).map(_.replace("\\", "/")).toList
  }

  def serverClassPath: List[String] = {
    val classpath = System.getProperty("java.class.path")
    classpath.split(System.getProperty("path.separator")).toList
  }

}

class InstallationInfo {
  @BeanProperty
  var plugins: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var hotfixes: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var classpathEntries: util.List[String] = new util.ArrayList[String]()
}

