package com.xebialabs.deployit.support

import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl
import com.xebialabs.deployit.core.rest.json.{ApplicationWithPackagesJsonWriter, EnvironmentsJsonWriter, TopNDeployedApplicationsReportLinesJsonWriter, TypeSystemDescriptorsDetailsJsonWriter}
import com.xebialabs.deployit.support.DefaultSupportReportService.NUMBER_OF_TOP_TASKS
import com.xebialabs.deployit.support.application.{DependencySupportReportService, EnvironmentSupportReportService}
import com.xebialabs.deployit.support.report.{TopNSupportReportService, TypeSystemDescriptorsDetails}
import org.joda.time.DateTime
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

object DefaultSupportReportService {
  val NUMBER_OF_TOP_TASKS = 10
}

@Service
class DefaultSupportReportService @Autowired()(topNSupportReportService: TopNSupportReportService,
                                               dependencySupportReportService: DependencySupportReportService,
                                               environmentSupportReportService: EnvironmentSupportReportService,
                                               topNDeployedApplicationsReportLinesJsonWriter: TopNDeployedApplicationsReportLinesJsonWriter,
                                               applicationWithPackagesJsonWriter: ApplicationWithPackagesJsonWriter,
                                               environmentsJsonWriter: EnvironmentsJsonWriter,
                                               typeSystemDescriptorsDetailsJsonWriter: TypeSystemDescriptorsDetailsJsonWriter) extends SupportReportService {
  override def collectApplicationsWithDependencies: String =
    applicationWithPackagesJsonWriter.toJson(dependencySupportReportService.fetchApplicationsWithDependencies.asJava)

  override def top10DeployedApplicationsInYear: String = {
    val end = DateTime.now
    val begin = end.minusYears(1)
    val lines = topNSupportReportService.topNDeployedApplications(begin, end.plusDays(1), NUMBER_OF_TOP_TASKS)
    topNDeployedApplicationsReportLinesJsonWriter.toJson(lines.asJava)
  }

  override def collectEnvironmentsWithMembersCount: String = {
    environmentsJsonWriter.toJson(environmentSupportReportService.getEnvironmentsWithMembersCount)
  }

  override def typeSystemDescriptorsDetails: String = {
    val metadataServiceImpl = new MetadataServiceImpl()
    val descriptors = metadataServiceImpl.listDescriptors()
    typeSystemDescriptorsDetailsJsonWriter.toJson(TypeSystemDescriptorsDetails(descriptors.size(), descriptors))
  }
}
