package com.xebialabs.deployit.support.application.sql

import com.xebialabs.deployit.core.sql.spring.Setter
import com.xebialabs.deployit.core.sql.{SchemaInfo, SelectBuilder}
import com.xebialabs.deployit.sql.base.schema.CIS
import com.xebialabs.deployit.support.application.EnvironmentSupportReportRepository
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.{JdbcTemplate, SingleColumnRowMapper}
import org.springframework.stereotype.Repository
import org.springframework.transaction.annotation.Transactional
import com.xebialabs.deployit.core.sql.{SqlCondition => cond}
import java.util.{List => JList}


@Repository
@Transactional(transactionManager = "mainTransactionManager")
class SqlEnvironmentSupportReportRepository(@Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                            @Autowired @Qualifier("mainSchema") implicit val schemaInfo: SchemaInfo
                                           ) extends EnvironmentSupportReportRepository {

  @Transactional(transactionManager = "mainTransactionManager", readOnly = true)
  override def getEnvironmentsPath: JList[String] = {
    val cis = "cis"
    val environmentType: String = "udm.Environment"
    val cisQuery = new SelectBuilder(CIS.tableName)
      .select(CIS.path)
      .as(cis)
      .where(cond.equals(CIS.ci_type.tableAlias(cis), environmentType))
    jdbcTemplate.query(cisQuery.query, Setter(cisQuery.parameters), new SingleColumnRowMapper[String]())
  }

}
