package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.support.report.TypeSystemDescriptorsDetails
import com.xebialabs.xltype.serialization.json.JsonWriter
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class TypeSystemDescriptorsDetailsJsonWriter extends AbstractJsonWriter[TypeSystemDescriptorsDetails] {
  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    classOf[TypeSystemDescriptorsDetails].isAssignableFrom(typeClass)

  override def writeTo(typeSystemDescriptorsDetails: TypeSystemDescriptorsDetails, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(typeSystemDescriptorsDetails).getBytes)

  override protected def writeJson(typeSystemDescriptorsDetails: TypeSystemDescriptorsDetails, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("numberOfTypes").value(typeSystemDescriptorsDetails.numberOfTypes)
    writer.key("types")
    writer.array()
    typeSystemDescriptorsDetails.types.forEach { descriptorDetails =>
      new DescriptorJsonWriter().writeJson(descriptorDetails, writer)
    }
    writer.endArray()
    writer.endObject()
  }
}
