package com.xebialabs.deployit.core.rest.json

import com.xebialabs.xltype.serialization.json.JsonWriter

import java.io.StringWriter
import javax.ws.rs.ext.MessageBodyWriter

trait AbstractJsonWriter[T] extends MessageBodyWriter[T] {
  def toJson(lines: T): String = {
    val stringWriter = new StringWriter
    val writer = new JsonWriter(stringWriter)
    writeJson(lines, writer)
    stringWriter.toString
  }

  protected def writeJson(lines: T, writer: JsonWriter)
}
