package com.xebialabs.deployit.core.api

import java.util.{List => JList}

import com.xebialabs.deployit.core.api.resteasy.Date
import com.xebialabs.deployit.support.application.{ApplicationWithPackages, Environments}
import com.xebialabs.deployit.support.report.{TopNDeployedApplicationsReportLine, TypeSystemDescriptorsDetails}
import javax.ws.rs._
import javax.ws.rs.core.MediaType

@Path("/internal/support/report")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait InternalSupportReport {

  @GET
  @Path("top10DeployedApplications")
  def top10DeployedApplications(@QueryParam("begin") begin: Date,
                                @QueryParam("end") end: Date,
                                @QueryParam("fetchSteps") fetchSteps: Boolean): JList[TopNDeployedApplicationsReportLine]


  @GET
  @Path("application-dependencies")
  def getApplicationsWithDependencies: JList[ApplicationWithPackages]

  @GET
  @Path("environments-details")
  def getEnvironmentsWithMembersCount: Environments

  @Path("typeSystemDescriptorsDetails")
  def getTypeSystemDescriptorsDetails: TypeSystemDescriptorsDetails
}
