package com.xebialabs.deployit.support.config

import ai.digital.configuration.central.deploy.ServerSideProperties
import com.xebialabs.deployit.core.api.dto.InternalReport
import com.xebialabs.deployit.support.SupportReportService
import com.xebialabs.xlplatform.support.rest.SupportAcceleratorConfiguration
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

import scala.collection.mutable.ListBuffer

@Configuration
class SupportAcceleratorConfig {

  @Autowired var supportReportService: SupportReportService = _

  @Autowired var serversideProperties: ServerSideProperties = _

  private val ZIP_FILENAME_PREFIX = "xld-support-package"
  private val DIRECTORIES_TO_PACK = List("centralConfiguration", "conf", "ext", "hotfix", "log", "bin")
  private val DIRECTORIES_TO_LIST = List("plugins", "lib")

  @Bean
  def internalReport(): List[InternalReport] = {
    var internalReport = new ListBuffer[InternalReport]()
    if (serversideProperties.supportPackageSettings.canDownloadTopDeployedApps)
      internalReport += new InternalReport ("Top10BiggestDeployedApplicationsInYear", "json",
    () => supportReportService.top10DeployedApplicationsInYear)
    if (serversideProperties.supportPackageSettings.canDownloadAppDependencies)
      internalReport += new InternalReport ("ApplicationsDependencies", "json",
    () => supportReportService.collectApplicationsWithDependencies)
    if (serversideProperties.supportPackageSettings.canDownloadEnvironments)
      internalReport += new InternalReport ("EnvironmentsDetails", "json",
    () => supportReportService.collectEnvironmentsWithMembersCount)
    if (serversideProperties.supportPackageSettings.canDownloadDescriptors)
      internalReport += new InternalReport ("TypeSystemDescriptorsDetails", "json",
    () => supportReportService.typeSystemDescriptorsDetails)
    internalReport.toList
  }

  @Bean
  def supportAcceleratorConfiguration(): SupportAcceleratorConfiguration = {
    SupportAcceleratorConfiguration(ZIP_FILENAME_PREFIX, DIRECTORIES_TO_PACK, DIRECTORIES_TO_LIST, internalReport)
  }
}
