package com.xebialabs.deployit.core.rest.support.report

import java.util.{List => JList}

import com.xebialabs.deployit.core.api.InternalSupportReport
import com.xebialabs.deployit.core.api.resteasy.Date
import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.deployit.support.DefaultSupportReportService.NUMBER_OF_TOP_TASKS
import com.xebialabs.deployit.support.application.{ApplicationWithPackages, DependencySupportReportService, EnvironmentSupportReportService, Environments}
import com.xebialabs.deployit.support.report.{TopNDeployedApplicationsReportLine, TopNSupportReportService, TypeSystemDescriptorsDetails}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import scala.jdk.CollectionConverters._

@Controller
class InternalSupportReportResource(@Autowired topNSupportReportService: TopNSupportReportService,
                                    @Autowired dependencySupportReportService: DependencySupportReportService,
                                    @Autowired environmentSupportReportService: EnvironmentSupportReportService
                                   ) extends AbstractSecuredResource with InternalSupportReport {

  override def top10DeployedApplications(begin: Date, end: Date, fetchSteps: Boolean): JList[TopNDeployedApplicationsReportLine] = {
    checkPermission(ADMIN)
    topNSupportReportService.topNDeployedApplications(begin.asDateTime(), end.asDateTime(), NUMBER_OF_TOP_TASKS, fetchSteps)
      .asJava
  }

  override def getApplicationsWithDependencies: JList[ApplicationWithPackages] = {
    checkPermission(ADMIN)
    dependencySupportReportService.fetchApplicationsWithDependencies.asJava
  }

  override def getEnvironmentsWithMembersCount: Environments = {
    checkPermission(ADMIN)
    environmentSupportReportService.getEnvironmentsWithMembersCount
  }

  override def getTypeSystemDescriptorsDetails: TypeSystemDescriptorsDetails = {
    checkPermission(ADMIN)
    val metadataServiceImpl = new MetadataServiceImpl
    val descriptors = metadataServiceImpl.listDescriptors()
    TypeSystemDescriptorsDetails(descriptors.size(), descriptors)
  }
}
