package com.xebialabs.deployit.core.rest.json

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import com.xebialabs.deployit.support.application.Environments
import com.xebialabs.xltype.serialization.json.JsonWriter
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class EnvironmentsJsonWriter extends AbstractJsonWriter[Environments] {

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    Environments.getClass.isAssignableFrom(typeClass)


  override def writeTo(line: Environments, typeClass: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(line).getBytes)

  override protected def writeJson(environments: Environments, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("numberOfEnvironments").value(environments.numberOfEnvironments)
    writer.key("environments").array()
    environments.environments.asJava.forEach { environment =>
      writer.`object`()
      writer.key("id").value(environment.id)
      writer.key("numberOfContainers").value(environment.numberOfContainers)
      writer.key("numberOfDictionaries").value(environment.numberOfDictionaries)
      writeReference("dictionary", environment.dictionaries, writer)
      writer.endObject()
    }
    writer.endArray()
    writer.endObject()
  }

  private def writeReference(key: String, dictionary: Map[String, Int], writer: JsonWriter): Unit = {
    writer.key(key)
    writer.`object`()
    writer.key("numberOfRestrictedApplication").value(dictionary.getOrElse("numberOfRestrictedApplication", 0))
    writer.key("numberOfRestrictedContainer").value(dictionary.getOrElse("numberOfRestrictedContainer", 0))
    writer.key("numberOfNonRestricted").value(dictionary.getOrElse("numberOfNonRestricted", 0))
    writer.key("numberOfBothRestricted").value(dictionary.getOrElse("numberOfBothRestricted", 0))
    writer.endObject()
  }
}
