package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.support.report.TopNDeployedApplicationsReportLine
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{Collection => JCollection}
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class TopNDeployedApplicationsReportLinesJsonWriter extends AbstractJsonWriter[JCollection[TopNDeployedApplicationsReportLine]] {

  private val matcher = new TypeMatcher(classOf[JCollection[_]], classOf[TopNDeployedApplicationsReportLine])
  private val topNDeployedApplicationsReportLineJsonWriter = new TopNDeployedApplicationsReportLineJsonWriter

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(topNDeployedApplicationsReportLines: JCollection[TopNDeployedApplicationsReportLine], typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(topNDeployedApplicationsReportLines).getBytes)

  override protected def writeJson(lines: JCollection[TopNDeployedApplicationsReportLine], writer: JsonWriter): Unit = {
    writer.array
    lines.forEach { topNDeployedApplicationsReportLine =>
      topNDeployedApplicationsReportLineJsonWriter.writeJson(topNDeployedApplicationsReportLine, writer)
    }
    writer.endArray
  }
}
