package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.support.report.TopNDeployedApplicationsReportLine
import com.xebialabs.xltype.serialization.json.JsonWriter
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class TopNDeployedApplicationsReportLineJsonWriter extends AbstractJsonWriter[TopNDeployedApplicationsReportLine] {

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    TopNDeployedApplicationsReportLine.getClass.isAssignableFrom(typeClass)

  override def writeTo(line: TopNDeployedApplicationsReportLine, typeClass: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(line).getBytes)

  override protected[json] def writeJson(line: TopNDeployedApplicationsReportLine, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("environment").value(line.environmentId)
    writer.key("deployedApplication").value(line.deployedApplicationId)
    writer.key("amountOfDeployeds").value(line.amountOfDeployeds.toLong)
    writer.key("amountOfResolvedPlaceholders").value(line.amountOfResolvedPlaceholders.toLong)
    writer.key("optimizePlan").value(line.optimizePlan)

    writer.key("orchestrators").array()
    line.orchestrators.foreach { orchestrator =>
      writer.value(orchestrator)
    }
    writer.endArray()

    writer.key("topTasks").array()
    line.topTasks.foreach { topTask =>
      writer.`object`()
        .key("durationMillis").value(topTask.durationMillis)
        .key("taskId").value(topTask.taskId)
      if (topTask.slowestSteps.nonEmpty) {
        writer.key("numberOfSteps").value(topTask.numberOfSteps.toLong)
        writer.key("slowestSteps").array()
        topTask.slowestSteps.foreach { slowestStepsDurationMilli =>
          writer.`object`()
            .key("description").value(slowestStepsDurationMilli._1)
            .key("duration").value(slowestStepsDurationMilli._2)
          writer.endObject()
        }
        writer.endArray()
      }
      writer.endObject()
    }
    writer.endArray()

    writer.key("artifacts").`object`()
      .key("numberNotFoundArtifacts").value(line.artifacts.numberNotFoundArtifacts.toLong)
      .key("numberOfResolvedPlaceholders").value(line.artifacts.numberOfResolvedPlaceholders.toLong)
    writer.key("scanPlaceholdersOnArtifacts").`object`()
      .key("sizeOfBytes").value(line.artifacts.scanPlaceholdersOn.sizeOfBytes)
      .key("number").value(line.artifacts.scanPlaceholdersOn.number.toLong)
    writer.endObject()
    writer.key("scanPlaceholdersOffArtifacts").`object`()
      .key("sizeOfBytes").value(line.artifacts.scanPlaceholdersOff.sizeOfBytes)
      .key("number").value(line.artifacts.scanPlaceholdersOff.number.toLong)
    writer.endObject()
    writer.endObject()

    writer.endObject()
  }
}
