/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.support.report;

import ai.digital.deploy.metrics.model.CiCount;
import ai.digital.deploy.metrics.repository.CiMetricsRepository;
import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.api.TaskMonitorService;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.support.report.CiStatistics;
import com.xebialabs.deployit.support.report.ControlTaskStatistics;
import com.xebialabs.deployit.support.report.DataStatisticsRepositoryService;
import com.xebialabs.deployit.support.report.DeploymentStatistics;
import com.xebialabs.deployit.support.report.FolderStatistics;
import com.xebialabs.deployit.support.report.UserAndRoleStatistics;
import com.xebialabs.deployit.support.report.report$;
import com.xebialabs.xlplatform.support.report.ReportDataProvider;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00036\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b=\u0003A\u0011\u0001)\t\u000f\u0011\u0004!\u0019!C\u0001K\"1\u0011\u000f\u0001Q\u0001\n\u0019DQA\u001d\u0001\u0005BMDQA\u001f\u0001\u0005\u0002mDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u0010\u0001\t\u0003\tyD\u0001\fECR\f7\u000b^1uSN$\u0018nY:Qe>4\u0018\u000eZ3s\u0015\t\u0019B#\u0001\u0004sKB|'\u000f\u001e\u0006\u0003+Y\tqa];qa>\u0014HO\u0003\u0002\u00181\u0005AA-\u001a9m_fLGO\u0003\u0002\u001a5\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00027\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)#&D\u0001'\u0015\t\u0019rE\u0003\u0002\u0016Q)\u0011\u0011\u0006G\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA\u0016'\u0005I\u0011V\r]8si\u0012\u000bG/\u0019)s_ZLG-\u001a:\u00021\u0011\fG/Y*uCRL7\u000f^5dgJ+\u0007o\\:ji>\u0014\u00180F\u0001/!\ty\u0003'D\u0001\u0013\u0013\t\t$CA\u0010ECR\f7\u000b^1uSN$\u0018nY:SKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f\u0011\u0004Z1uCN#\u0018\r^5ti&\u001c7OU3q_NLGo\u001c:zA\u0005\u00192-['fiJL7m\u001d*fa>\u001c\u0018\u000e^8ssV\tQ\u0007\u0005\u00027\u00036\tqG\u0003\u00029s\u0005Q!/\u001a9pg&$xN]=\u000b\u0005iZ\u0014aB7fiJL7m\u001d\u0006\u0003yu\na\u0001Z3qY>L(B\u0001 @\u0003\u001d!\u0017nZ5uC2T\u0011\u0001Q\u0001\u0003C&L!AQ\u001c\u0003'\rKW*\u001a;sS\u000e\u001c(+\u001a9pg&$xN]=\u0002)\rLW*\u001a;sS\u000e\u001c(+\u001a9pg&$xN]=!\u0003I!\u0018m]6N_:LGo\u001c:TKJ4\u0018nY3\u0016\u0003\u0019\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0007\u0005\u0004\u0018N\u0003\u0002L-\u0005!1m\u001c:f\u0013\ti\u0005J\u0001\nUCN\\Wj\u001c8ji>\u00148+\u001a:wS\u000e,\u0017a\u0005;bg.luN\\5u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003R%N#\u0006CA\u0018\u0001\u0011\u0015as\u00011\u0001/\u0011\u0015\u0019t\u00011\u00016\u0011\u0015!u\u00011\u0001GQ\t9a\u000b\u0005\u0002XE6\t\u0001L\u0003\u0002Z5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005mc\u0016a\u00024bGR|'/\u001f\u0006\u0003;z\u000bQAY3b]NT!a\u00181\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Y\u0001\u0004_J<\u0017BA2Y\u0005%\tU\u000f^8xSJ,G-\u0001\u0003oC6,W#\u00014\u0011\u0005\u001dtgB\u00015m!\tI\u0007%D\u0001k\u0015\tYG$\u0001\u0004=e>|GOP\u0005\u0003[\u0002\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q\u000eI\u0001\u0006]\u0006lW\rI\u0001\u0012G>dG.Z2u'R\fG/[:uS\u000e\u001cX#\u0001;\u0011\t\u001d,hm^\u0005\u0003mB\u00141!T1q!\ty\u00020\u0003\u0002zA\t\u0019\u0011I\\=\u0002'\r|G\u000e\\3di\u000eK7\u000b^1uSN$\u0018nY:\u0016\u0003q\u0004\"aL?\n\u0005y\u0014\"\u0001D\"j'R\fG/[:uS\u000e\u001c\u0018aG2pY2,7\r\u001e#fa2|\u00170\\3oiN#\u0018\r^5ti&\u001c7/\u0006\u0002\u0002\u0004A\u0019q&!\u0002\n\u0007\u0005\u001d!C\u0001\u000bEKBdw._7f]R\u001cF/\u0019;jgRL7m]\u0001\u0013O\u0016$H)\u001a9m_flWM\u001c;D_VtG\u000f\u0006\u0004\u0002\u000e\u0005M\u0011Q\u0005\t\u0004?\u0005=\u0011bAA\tA\t\u0019\u0011J\u001c;\t\rMi\u0001\u0019AA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQ!\\8eK2T1!a\b<\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003G\tIB\u0001\u0004SKB|'\u000f\u001e\u0005\u0007\u0003Oi\u0001\u0019\u00014\u0002\u001d\u0011,\u0007\u000f\\8z[\u0016tG\u000fV=qK\u000692m\u001c7mK\u000e$hi\u001c7eKJ\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003[\u00012aLA\u0018\u0013\r\t\tD\u0005\u0002\u0011\r>dG-\u001a:Ti\u0006$\u0018n\u001d;jGN\f\u0011eY8mY\u0016\u001cGoQ8oiJ|G\u000eV1tWV\u001b\u0018mZ3Ti\u0006$\u0018n\u001d;jGN,\"!a\u000e\u0011\u0007=\nI$C\u0002\u0002<I\u0011QcQ8oiJ|G\u000eV1tWN#\u0018\r^5ti&\u001c7/A\u000fd_2dWm\u0019;Vg\u0016\u00148/\u00118e%>dWm\u0015;bi&\u001cH/[2t+\t\t\t\u0005E\u00020\u0003\u0007J1!!\u0012\u0013\u0005U)6/\u001a:B]\u0012\u0014v\u000e\\3Ti\u0006$\u0018n\u001d;jGND3\u0001AA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(=\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005M\u0013Q\n\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DataStatisticsProvider
implements ReportDataProvider {
    private final DataStatisticsRepositoryService dataStatisticsRepository;
    private final CiMetricsRepository ciMetricsRepository;
    private final TaskMonitorService taskMonitorService;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DataStatisticsProvider dataStatisticsProvider = this;
        synchronized (dataStatisticsProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public DataStatisticsRepositoryService dataStatisticsRepository() {
        return this.dataStatisticsRepository;
    }

    public CiMetricsRepository ciMetricsRepository() {
        return this.ciMetricsRepository;
    }

    public TaskMonitorService taskMonitorService() {
        return this.taskMonitorService;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> collectStatistics() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ci"), (Object)this.collectCiStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployments"), (Object)this.collectDeploymentStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks"), (Object)this.collectControlTaskUsageStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folders"), (Object)this.collectFolderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)this.collectUsersAndRoleStatistics())}))).asJava())}));
    }

    /*
     * WARNING - void declaration
     */
    public CiStatistics collectCiStatistics() {
        void var1_1;
        CiStatistics statistics = new CiStatistics();
        CiCount applicationCount = this.ciMetricsRepository().getCisCount((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"udm.Application"})), (Option)new Some((Object)"/Applications"), null, null, null);
        statistics.totalApplication_$eq((int)applicationCount.ciCount());
        statistics.totalHosts_$eq(this.dataStatisticsRepository().hostCount());
        statistics.totalSatellites_$eq(this.dataStatisticsRepository().satelliteCount());
        statistics.totalWorker_$eq(this.dataStatisticsRepository().workersCount());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeploymentStatistics collectDeploymentStatistics() {
        void var1_1;
        DeploymentStatistics statistics = new DeploymentStatistics();
        Date fromDate = new Date(DateTime.now().minusDays(30).toDate().toString());
        Date toDate = new Date(DateTime.now().toDate().toString());
        Date from24hrs = new Date(DateTime.now().minusHours(24).toDate().toString());
        Report reportFor24hrs = this.dataStatisticsRepository().getDeploymentReportForAPeriod(from24hrs, toDate);
        statistics.successfulDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "successful"));
        statistics.rollbackDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "rollback"));
        statistics.abortedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "aborted"));
        statistics.retriedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "failed"));
        statistics.totalDeploymentFor24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "totalDeployment"));
        Report reportFor30days = this.dataStatisticsRepository().getDeploymentReportForAPeriod(fromDate, toDate);
        statistics.totalDeploymentFor30days_$eq(this.getDeploymentCount(reportFor30days, "totalDeployment"));
        statistics.averageDeploymentPerDayPerMonth_$eq(report$.MODULE$.avg(statistics.totalDeploymentFor30days(), 30));
        Date forAYear = new Date(DateTime.now().minusDays(365).toDate().toString());
        Report reportForAYear = this.dataStatisticsRepository().getDeploymentReportForAPeriod(forAYear, toDate);
        int totalDeploymentForYr = this.getDeploymentCount(reportForAYear, "totalDeployment");
        statistics.averageDeploymentPerDayPerYr_$eq(report$.MODULE$.avg(totalDeploymentForYr, 365));
        statistics.totalPendingDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, true, true, true));
        statistics.totalScheduledDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, false, false, false));
        statistics.totalQueuedDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", false, false, true, false));
        statistics.activeDeployments_$eq(this.dataStatisticsRepository().activeTaskCount("deployment"));
        return var1_1;
    }

    public int getDeploymentCount(Report report2, String deploymentType) {
        int n;
        block7: {
            int successful = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfSuccessfulDeployments").toString()));
            int rollBack = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfRollbacks").toString()));
            int failed = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfFailedDeployments").toString()));
            int aborted = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfAbortedDeployments").toString()));
            int totalDeployment = successful + rollBack + failed + aborted;
            String string = deploymentType;
            switch (string == null ? 0 : string.hashCode()) {
                case -1281977283: {
                    if (!"failed".equals(string)) break;
                    n = failed;
                    break block7;
                }
                case -1194777649: {
                    if (!"aborted".equals(string)) break;
                    n = aborted;
                    break block7;
                }
                case -733631846: {
                    if (!"successful".equals(string)) break;
                    n = successful;
                    break block7;
                }
                case -259719452: {
                    if (!"rollback".equals(string)) break;
                    n = rollBack;
                    break block7;
                }
                case 1596796201: {
                    if (!"totalDeployment".equals(string)) break;
                    n = totalDeployment;
                    break block7;
                }
            }
            throw new MatchError((Object)string);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public FolderStatistics collectFolderStatistics() {
        void var1_1;
        FolderStatistics statistics = new FolderStatistics();
        statistics.applicationFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Applications")).foldersCount());
        statistics.environmentFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Environments")).foldersCount());
        statistics.infraFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Infrastructure")).foldersCount());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ControlTaskStatistics collectControlTaskUsageStatistics() {
        void var1_1;
        ControlTaskStatistics controlTaskStatistics = new ControlTaskStatistics();
        int totalActiveTasks = this.dataStatisticsRepository().activeTaskCount("Control task");
        controlTaskStatistics.setTotalActiveTasks(totalActiveTasks);
        int pendingCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, true, true, true);
        controlTaskStatistics.setTotalPendingTasks(pendingCount);
        int scheduledCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, false, false, false);
        controlTaskStatistics.setTotalScheduledTasks(scheduledCount);
        int queuedCount = this.dataStatisticsRepository().pendingTaskCount("Control task", false, false, true, false);
        controlTaskStatistics.setTotalQueuedTasks(queuedCount);
        int completedCountFor24Years = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.DONE.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalSuccessfulTasksFor24Years(completedCountFor24Years);
        int abortedCountFor24Years = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.CANCELLED.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalAbortedTasksFor24Years(abortedCountFor24Years);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UserAndRoleStatistics collectUsersAndRoleStatistics() {
        void var1_1;
        UserAndRoleStatistics statistics = new UserAndRoleStatistics();
        statistics.totalActiveUsers_$eq(this.dataStatisticsRepository().totalActiveUsersCount());
        statistics.totalGlobalRoles_$eq(this.dataStatisticsRepository().totalGlobalRoleCount());
        return var1_1;
    }

    @Autowired
    public DataStatisticsProvider(DataStatisticsRepositoryService dataStatisticsRepository, CiMetricsRepository ciMetricsRepository, TaskMonitorService taskMonitorService) {
        this.dataStatisticsRepository = dataStatisticsRepository;
        this.ciMetricsRepository = ciMetricsRepository;
        this.taskMonitorService = taskMonitorService;
        Logging.$init$((Logging)this);
        this.name = "data";
    }
}

