/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ExtendedActorSystem;
import com.xebialabs.deployit.core.TypeConversions$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.KryoBasedSerializer;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001\u0002\u000f\u001e\u00011B\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0011\"AQ\u000b\u0001BC\u0002\u0013\ra\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\n\u0001\t\u0003\nI\u0003C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u001d\tI\n\u0001C\u0005\u00037C\u0011\"!8\u0001#\u0003%I!a\u001a\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\t=\u0002\u0001\"\u0011\u00032!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'BqAa\u0016\u0001\t\u0013\u0011IF\u0001\rTc2\u0004VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pefT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\t\u001a\u0013A\u0002;bg.,'O\u0003\u0002%K\u00051QM\\4j]\u0016T!AJ\u0014\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001K\u0015\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\r\u0001i3gN\u001e?!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'N\u0007\u0002?%\u0011ag\b\u0002\u0016!\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z!\tA\u0014(D\u0001\u001e\u0013\tQTDA\nQK:$\u0017N\\4UCN\\7/U;fe&,7\u000f\u0005\u00029y%\u0011Q(\b\u0002\u001b!\u0016tG-\u001b8h)\u0006\u001c8.T3uC\u0012\fG/Y)vKJLWm\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQa\u001d7gi)T\u0011aQ\u0001\tOJL'P\u001f7fI&\u0011Q\t\u0011\u0002\b\u0019><w-\u001b8h\u00031QGMY2UK6\u0004H.\u0019;f+\u0005A\u0005CA%S\u001b\u0005Q%BA&M\u0003\u0011\u0019wN]3\u000b\u00055s\u0015\u0001\u00026eE\u000eT!a\u0014)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!U\u0001\u0004_J<\u0017BA*K\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\b.\u000b\u0005-+\u0013B\u0001/Z\u0005)\u0019\u0016\u000f\u001c#jC2,7\r^\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003AV$\"!\u00192\u0011\u0005a\u0002\u0001\"B+\u0006\u0001\b9\u0006\u0006\u00022e]>\u0004\"!\u001a7\u000e\u0003\u0019T!a\u001a5\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002jU\u00069a-Y2u_JL(BA6O\u0003\u0015\u0011W-\u00198t\u0013\tigMA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n\u0001/\u0001\bnC&t7+\u001d7ES\u0006dWm\u0019;)\u0005\t\u0014\bCA3t\u0013\t!hMA\u0005BkR|w/\u001b:fI\")a)\u0002a\u0001\u0011\"\"Q\u000f\u001a8xC\u0005A\u0018\u0001E7bS:TEMY2UK6\u0004H.\u0019;fQ\t)(/A\u0003uCN\\7\u000fF\u0002}\u00033\u0001R!`A\u0003\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001B;uS2T!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(\u0001\u0002'jgR\u0004B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0019\u00111C\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0018\u00055!!\u0004+bg.<\u0016\u000e\u001e5CY>\u001c7\u000eC\u0004\u0002\u001c\u0019\u0001\r!!\b\u0002\u00191|\u0017\r\u001a$vY2\u001c\u0006/Z2\u0011\u00079\ny\"C\u0002\u0002\"=\u0012qAQ8pY\u0016\fg.\u0001\btG\",G-\u001e7fIR\u000b7o[:\u0015\u0003q\fA\u0001^1tWR1\u00111FA\u001c\u0003G\u0002RALA\u0017\u0003cI1!a\f0\u0005\u0019y\u0005\u000f^5p]B\u0019A'a\r\n\u0007\u0005UrDA\u0006QK:$\u0017N\\4UCN\\\u0007bBA\u001d\u0011\u0001\u0007\u00111H\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005u\u0012Q\f\b\u0005\u0003\u007f\tIF\u0004\u0003\u0002B\u0005]c\u0002BA\"\u0003+rA!!\u0012\u0002T9!\u0011qIA)\u001d\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'W\u00051AH]8pizJ\u0011AK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\r\tY&I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\rQ\u000b7o[%e\u0015\r\tY&\t\u0005\n\u00037A\u0001\u0013!a\u0001\u0003;\ta\u0002^1tW\u0012\"WMZ1vYR$#'\u0006\u0002\u0002j)\"\u0011QDA6W\t\ti\u0007\u0005\u0003\u0002p\u0005]TBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'BA40\u0013\u0011\tI(!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$7+^7nCJLH\u0003BA\u0016\u0003\u007fBq!!\u000f\u000b\u0001\u0004\tY$\u0001\u0007sK\u0006$g)\u001e7m'B,7\r\u0006\u0003\u0002,\u0005\u0015\u0005bBA\u001d\u0017\u0001\u0007\u00111H\u0001\u000ei>\u0004VM\u001c3j]\u001e$\u0016m]6\u0015\t\u0005E\u00121\u0012\u0005\b\u0003\u001bc\u0001\u0019AAH\u0003\t\u00118\u000f\u0005\u0003\u0002\u0012\u0006UUBAAJ\u0015\rq\u0012\u0011A\u0005\u0005\u0003/\u000b\u0019JA\u0005SKN,H\u000e^*fi\u0006)\u0002/\u001a8eS:<G+Y:l\rJ|WNQ5oCJLH\u0003DA\u0019\u0003;\u000by+a0\u0002T\u0006e\u0007bBA\u001d\u001b\u0001\u0007\u0011q\u0014\t\u0005\u0003C\u000bIK\u0004\u0003\u0002$\u0006\u0015\u0006cAA%_%\u0019\u0011qU\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\tY+!,\u0003\rM#(/\u001b8h\u0015\r\t9k\f\u0005\b\u0003ck\u0001\u0019AAZ\u00035!\u0018m]6Ta\u0016\u001c')\u001f;fgB)a&!.\u0002:&\u0019\u0011qW\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00079\nY,C\u0002\u0002>>\u0012AAQ=uK\"9\u0011\u0011Y\u0007A\u0002\u0005\r\u0017!D:dQ\u0016$W\u000f\\3e\t\u0006$X\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\tQLW.\u001a\u0006\u0004\u0003\u001b\u0004\u0016\u0001\u00026pI\u0006LA!!5\u0002H\nAA)\u0019;f)&lW\rC\u0004\u0002V6\u0001\r!a6\u0002\u001b]|'o[3s\u0003\u0012$'/Z:t!\u0015q\u0013QFAP\u0011%\tY.\u0004I\u0001\u0002\u0004\ti\"A\u0007jgN+g\u000e\u001e+p#V,W/Z\u0001 a\u0016tG-\u001b8h)\u0006\u001c8N\u0012:p[\nKg.\u0019:zI\u0011,g-Y;mi\u0012*\u0014!B:u_J,GCBA\u001e\u0003G\fy\u000fC\u0004\u0002f>\u0001\r!a:\u0002\tM\u0004Xm\u0019\t\u0005\u0003S\fY/D\u0001\"\u0013\r\ti/\t\u0002\u0012)\u0006\u001c8n\u00159fG&4\u0017nY1uS>t\u0007\"CAk\u001fA\u0005\t\u0019AAl\u0003\u0019)\b\u000fZ1uKR1\u0011Q_A~\u0003{\u00042ALA|\u0013\r\tIp\f\u0002\u0005+:LG\u000fC\u0004\u0002:A\u0001\r!a\u000f\t\u000f\u0005\u0015\b\u00031\u0001\u0002h\u0006a1\u000f]3d)>\u0014\u0015N\\1ssR!\u00111\u0017B\u0002\u0011\u001d\t)/\u0005a\u0001\u0003O\f!b]3sS\u0006d\u0017N_3s+\t\u0011I\u0001\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011y!I\u0001\ng\u0006$X\r\u001c7ji\u0016LAAa\u0005\u0003\u000e\t\u00192J]=p\u0005\u0006\u001cX\rZ*fe&\fG.\u001b>fe\u0006Y1\r[1oO\u0016|uO\\3s)\u0019\t)P!\u0007\u0003\u001c!9\u0011\u0011H\nA\u0002\u0005m\u0002b\u0002B\u000f'\u0001\u0007\u0011qT\u0001\t]\u0016<xj\u001e8fe\u0006A1o\u00195fIVdW\r\u0006\u0004\u0002v\n\r\"Q\u0005\u0005\b\u0003s!\u0002\u0019AA\u001e\u0011\u001d\u00119\u0003\u0006a\u0001\u0003\u0007\fA\u0001Z1uK\u00061A-\u001a7fi\u0016$B!!>\u0003.!9\u0011\u0011H\u000bA\u0002\u0005m\u0012\u0001\u00059sKB\f'/\u001a+p\u000b:\fX/Z;f)\u0011\u0011\u0019D!\u0010\u0011\r\tU\"\u0011HA\u0005\u001b\t\u00119D\u0003\u0002\u0000_%!!1\bB\u001c\u0005\r!&/\u001f\u0005\b\u0003s1\u0002\u0019AA\u001e\u00035)\u0007\u0010\u001e:bGR$\u0016m]6JIR!\u00111\bB\"\u0011\u001d\tii\u0006a\u0001\u0003\u001f\u000bA#\u001a=ue\u0006\u001cGoV8sW\u0016\u0014\u0018\t\u001a3sKN\u001cH\u0003BAl\u0005\u0013Bq!!$\u0019\u0001\u0004\ty)\u0001\u000bfqR\u0014\u0018m\u0019;TG\",G-\u001e7fI\u0012\u000bG/\u001a\u000b\u0005\u0003\u0007\u0014y\u0005C\u0004\u0002\u000ef\u0001\r!a$\u00021\u0015DHO]1diR\u000b7o[*qK\u000eLg-[2bi&|g\u000e\u0006\u0003\u00024\nU\u0003bBAG5\u0001\u0007\u0011qR\u0001\u0015Kb$(/Y2u\u0013N\u001cVM\u001c;U_F+X-^3\u0015\t\u0005u!1\f\u0005\b\u0003\u001b[\u0002\u0019AAHQ\u0019\u0001!q\f8\u0003nA!!\u0011\rB5\u001b\t\u0011\u0019GC\u0002h\u0005KR1Aa\u001aO\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\t-$1\r\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\t=\u0014AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0007\u0001\u0011\u0019\b\u0005\u0003\u0003v\tmTB\u0001B<\u0015\r\u0011IHT\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B?\u0005o\u0012\u0011bQ8na>tWM\u001c;")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 1) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 8) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x10) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x40) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x400) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.toPendingTask(rs))).asScala()).toList() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.head();
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull(Predef$.MODULE$.$conforms());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (rs, x$3) -> this.toPendingTask(rs));
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$4) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$5) -> this.toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    private PendingTask toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pendingTask = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull(Predef$.MODULE$.$conforms())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> exception.getMessage(), (Function0 & Serializable & scala.Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoBasedSerializer serializer() {
        return new KryoAkkaSerializer((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()).serializer();
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
    }

    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        Failure failure;
        SimpleSelectBuilder q = this.sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$6) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        } else if (option instanceof Some) {
            Failure failure2;
            Some some = (Some)option;
            PendingTask task = (PendingTask)some.value();
            if (task.isSentToQueue()) {
                failure2 = new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            } else {
                Success success;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId}));
                if (try_ instanceof Success) {
                    success = new Success((Object)task);
                } else if (try_ instanceof Failure) {
                    Failure failure3 = (Failure)try_;
                    Throwable ex = failure3.exception();
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> ex.getMessage(), (Function0 & Serializable & scala.Serializable)() -> ex);
                    success = new Failure(ex);
                } else {
                    throw new MatchError((Object)try_);
                }
                failure2 = success;
            }
            failure = failure2;
        } else {
            throw new MatchError(option);
        }
        return failure;
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull(Predef$.MODULE$.$conforms());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

