/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.spring.Setter;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import com.xebialabs.deployit.security.sql.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u000b\u0017\u0001\u0005B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005i!A\u0011\t\u0001BC\u0002\u0013\r!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaa\u001b\u0001!\u0002\u0013A\u0007\"\u00027\u0001\t\u0013i\u0007bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA1\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\tY\b\u0001C!\u0003{Bq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0004\u0002!\t%a%\u0003\u001dM\u000bH.V:feN+'O^5dK*\u0011q\u0003G\u0001\u0004gFd'BA\r\u001b\u0003!\u0019XmY;sSRL(BA\u000e\u001d\u0003!!W\r\u001d7ps&$(BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001!E\u000b\u0018\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t1qJ\u00196fGR\u0004\"a\u000b\u0017\u000e\u0003aI!!\f\r\u0003\u0017U\u001bXM]*feZL7-\u001a\t\u0003_Aj\u0011AF\u0005\u0003cY\u00111\"V:feF+XM]5fg\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\tA\u0007\u0005\u00026}5\taG\u0003\u00028q\u0005!1m\u001c:f\u0015\tI$(\u0001\u0003kI\n\u001c'BA\u001e=\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@m\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\n!b]9m\t&\fG.Z2u+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%BA\fG\u0015\t9$$\u0003\u0002I\u000b\nQ1+\u001d7ES\u0006dWm\u0019;\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051\u000bGCA'O!\ty\u0003\u0001C\u0003B\u000b\u0001\u000f1\t\u000b\u0003O!j[\u0006CA)Y\u001b\u0005\u0011&BA*U\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003+Z\u000bqAZ1di>\u0014\u0018P\u0003\u0002Xu\u0005)!-Z1og&\u0011\u0011L\u0015\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013\u0001X\u0001\u000f[\u0006LgnU9m\t&\fG.Z2uQ\tqe\f\u0005\u0002R?&\u0011\u0001M\u0015\u0002\n\u0003V$xn^5sK\u0012DQAM\u0003A\u0002QBC!\u0019)[G\u0006\nA-\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u0012\u0011MX\u0001\u0010a\u0006\u001c8o^8sI\u0016s7m\u001c3feV\t\u0001\u000e\u0005\u0002,S&\u0011!\u000e\u0007\u0002\u0016'\"\u000b%'\u000e\u001cQCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s\u0003A\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014\b%\u0001\nxSRDWk]3s]\u0006lWMR5mi\u0016\u0014H\u0003\u00028u\u0003\u0007\u0001\"a\u001c:\u000e\u0003AT\u0011!]\u0001\u0006g\u000e\fG.Y\u0005\u0003gB\u00141!\u00118z\u0011\u0015)\b\u00021\u0001w\u0003!)8/\u001a:oC6,\u0007CA<\u007f\u001d\tAH\u0010\u0005\u0002za6\t!P\u0003\u0002|A\u00051AH]8pizJ!! 9\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0004\bbBA\u0003\u0011\u0001\u0007\u0011qA\u0001\bEVLG\u000eZ3s!\r!\u0015\u0011B\u0005\u0004\u0003\u0017)%!D*fY\u0016\u001cGOQ;jY\u0012,'/\u0001\u0006d_VtG/V:feN$B!!\u0005\u0002\u0018A\u0019q.a\u0005\n\u0007\u0005U\u0001O\u0001\u0003M_:<\u0007\"B;\n\u0001\u00041\bFB\u0005\u0002\u001ci\u000b\t\u0003E\u0002$\u0003;I1!a\b%\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7\u000f\f\u0002\u0002$\u0005\u0012\u0011QE\u0001\u0004C2d\u0017AE2iK\u000e\\g+\u00197jIV\u001bXM\u001d8b[\u0016$B!a\u000b\u00022A\u0019q.!\f\n\u0007\u0005=\u0002O\u0001\u0003V]&$\b\"B;\u000b\u0001\u00041\u0018AE2iK\u000e\\\u0017\tZ7j]V\u001bXM\u001d8b[\u0016$B!a\u000b\u00028!)Qo\u0003a\u0001m\u0006A!/Z1e+N,'\u000f\u0006\u0003\u0002>\u0005%\u0003#B8\u0002@\u0005\r\u0013bAA!a\n1q\n\u001d;j_:\u00042aLA#\u0013\r\t9E\u0006\u0002\r\u0013:$XM\u001d8bYV\u001bXM\u001d\u0005\u0006k2\u0001\rA^\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002P\u0005U\u0003cA\u0016\u0002R%\u0019\u00111\u000b\r\u0003\tU\u001bXM\u001d\u0005\u0006k6\u0001\rA^\u0001\rCV$\b.\u001a8uS\u000e\fG/\u001a\u000b\u0007\u0003W\tY&!\u0018\t\u000bUt\u0001\u0019\u0001<\t\r\u0005}c\u00021\u0001w\u0003!\u0001\u0018m]:x_J$\u0017AD7pI&4\u0017\u0010U1tg^|'\u000f\u001a\u000b\u0007\u0003W\t)'a\u001a\t\u000bU|\u0001\u0019\u0001<\t\r\u0005%t\u00021\u0001w\u0003-qWm\u001e)bgN<xN\u001d3\u0015\u0011\u0005-\u0012QNA8\u0003cBQ!\u001e\tA\u0002YDa!!\u001b\u0011\u0001\u00041\bBBA:!\u0001\u0007a/A\u0006pY\u0012\u0004\u0016m]:x_J$\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002,\u0005e\u0004\"B;\u0012\u0001\u00041\u0018AB2sK\u0006$X\r\u0006\u0004\u0002,\u0005}\u0014\u0011\u0011\u0005\u0006kJ\u0001\rA\u001e\u0005\u0007\u0003?\u0012\u0002\u0019\u0001<\u0002\u001b1L7\u000f^+tKJt\u0017-\\3t)\t\t9\tE\u0003\u0002\n\u0006=e/\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\u000bYI\u0001\u0003MSN$H\u0003CAD\u0003+\u000b9*a,\t\u000bU$\u0002\u0019\u0001<\t\u000f\u0005eE\u00031\u0001\u0002\u001c\u00061\u0001/Y4j]\u001e\u0004B!!(\u0002,6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0002ei>TA!!*\u0002(\u0006\u0019\u0011\r]5\u000b\u0007\u0005%&$\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003[\u000byJ\u0001\u0004QC\u001eLgn\u001a\u0005\b\u0003c#\u0002\u0019AAZ\u0003\u0015y'\u000fZ3s!\u0011\ti*!.\n\t\u0005]\u0016q\u0014\u0002\t\u001fJ$WM]5oO\"2\u0001!a/[\u0003\u0013\u0004B!!0\u0002F6\u0011\u0011q\u0018\u0006\u0004'\u0006\u0005'bAAbu\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t9-a0\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1mC\t\tY-\u0001\fnC&tGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\u001d\u0001\u0011qZAo\u0003?\u0004B!!5\u0002Z6\u0011\u00111\u001b\u0006\u0004'\u0006U'bAAlu\u000591m\u001c8uKb$\u0018\u0002BAn\u0003'\u0014QaU2pa\u0016\f\u0011\u0002\u001d:pqflu\u000eZ3%\u0005\u0005\u0005\u0018\u0002BAr\u0003K\fA\u0002V!S\u000f\u0016#vl\u0011'B'NSA!a:\u0002T\u0006y1kY8qK\u0012\u0004&o\u001c=z\u001b>$W\rK\u0002\u0001\u0003W\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003cT\u0014AC:uKJ,w\u000e^=qK&!\u0011Q_Ax\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String SELECT;
    private final String SELECT_NAMES;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private Object withUsernameFilter(String username, SelectBuilder builder) {
        return username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringBuilder(2).append("%").append(username.toLowerCase()).append("%").toString())) : BoxedUnit.UNIT;
    }

    public long countUsers(String username) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)SqlFunction$.MODULE$.countAll());
        this.withUsernameFilter(username, builder);
        return BoxesRunTime.unboxToLong((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new SingleColumnRowMapper(Long.TYPE))).asScala()).head());
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private void checkAdminUsername(String username) {
        if ("admin".equalsIgnoreCase(username)) {
            throw new IllegalArgumentException("Admin user cannot be deleted.");
        }
    }

    private Option<InternalUser> readUser(String username) {
        return ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).asScala()).map((Function1 & Serializable & scala.Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())), Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(14).append("No such user: ").append(username).toString(), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringBuilder(20).append("Cannot authenticate ").append(username).toString());
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringBuilder(36).append("Wrong credentials supplied for user ").append(username).toString());
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.checkAdminUsername(username);
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        this.withUsernameFilter(username, builder);
        Object object = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object2 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())) : OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())))) : BoxedUnit.UNIT;
        List names = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new package.MapRowMapper())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        return package$.MODULE$.asMutableJavaList(names);
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String oldPassword$1, String username$4, String newPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
    }
}

