/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.Setter;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u00015\u0011abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u00111\"V:feN+'O^5dKB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\f+N,'/U;fe&,7\u000f\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u00031QGMY2UK6\u0004H.\u0019;f+\u0005\t\u0003C\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011\u0019wN]3\u000b\u0005\u0019:\u0013\u0001\u00026eE\u000eT!\u0001K\u0015\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AK\u0001\u0004_J<\u0017B\u0001\u0017$\u00051QEMY2UK6\u0004H.\u0019;f\u0011!q\u0003A!A!\u0002\u0013\t\u0013!\u00046eE\u000e$V-\u001c9mCR,\u0007\u0005\u0003\u00051\u0001\t\u0015\r\u0011b\u00012\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002eA\u00111GN\u0007\u0002i)\u00111!\u000e\u0006\u0003I\u0019I!a\u000e\u001b\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u00033\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\ti$\u000b\u0006\u0002?\u007fA\u00111\u0004\u0001\u0005\u0006ai\u0002\u001dA\r\u0015\u0005\u007f\u0005[E\n\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0019;\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0011\u001e\nQAY3b]NL!AS\"\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A'\u0002\u001d5\f\u0017N\\*rY\u0012K\u0017\r\\3di\"\u0012qh\u0014\t\u0003\u0005BK!!U\"\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B\u0010;\u0001\u0004\t\u0003\u0006\u0002*B\u0017R\u000b\u0013!V\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016D#AU(\t\u000fa\u0003!\u0019!C\u00013\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/F\u0001[!\t92,\u0003\u0002]\t\t)2\u000bS!3kY\u0002\u0016m]:x_J$WI\\2pI\u0016\u0014\bB\u00020\u0001A\u0003%!,\u0001\tqCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3sA!)\u0001\r\u0001C\u0005C\u0006\u0011r/\u001b;i+N,'O\\1nK\u001aKG\u000e^3s)\r\u0011\u0007.\u001e\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\u0004\u0003:L\b\"B5`\u0001\u0004Q\u0017\u0001C;tKJt\u0017-\\3\u0011\u0005-\u0014hB\u00017q!\tiG-D\u0001o\u0015\tyG\"\u0001\u0004=e>|GOP\u0005\u0003c\u0012\fa\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000f\u001a\u0005\u0006m~\u0003\ra^\u0001\bEVLG\u000eZ3s!\t\u0019\u00040\u0003\u0002zi\ti1+\u001a7fGR\u0014U/\u001b7eKJDQa\u001f\u0001\u0005Bq\f!bY8v]R,6/\u001a:t)\ri\u0018\u0011\u0001\t\u0003GzL!a 3\u0003\t1{gn\u001a\u0005\u0006Sj\u0004\rA\u001b\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003I\u0019\u0007.Z2l-\u0006d\u0017\u000eZ+tKJt\u0017-\\3\u0015\t\u0005%\u0011q\u0002\t\u0004G\u0006-\u0011bAA\u0007I\n!QK\\5u\u0011\u0019I\u00171\u0001a\u0001U\"9\u00111\u0003\u0001\u0005\n\u0005U\u0011\u0001\u0003:fC\u0012,6/\u001a:\u0015\t\u0005]\u00111\u0005\t\u0006G\u0006e\u0011QD\u0005\u0004\u00037!'AB(qi&|g\u000eE\u0002\u001c\u0003?I1!!\t\u0003\u00051Ie\u000e^3s]\u0006dWk]3s\u0011\u0019I\u0017\u0011\u0003a\u0001U\"9\u0011q\u0005\u0001\u0005B\u0005%\u0012\u0001\u0002:fC\u0012$B!a\u000b\u00022A\u0019q#!\f\n\u0007\u0005=BA\u0001\u0003Vg\u0016\u0014\bBB5\u0002&\u0001\u0007!\u000eC\u0004\u00026\u0001!\t%a\u000e\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\r\u0005%\u0011\u0011HA\u001e\u0011\u0019I\u00171\u0007a\u0001U\"9\u0011QHA\u001a\u0001\u0004Q\u0017\u0001\u00039bgN<xN\u001d3\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005qQn\u001c3jMf\u0004\u0016m]:x_J$GCBA\u0005\u0003\u000b\n9\u0005\u0003\u0004j\u0003\u007f\u0001\rA\u001b\u0005\b\u0003\u0013\ny\u00041\u0001k\u0003-qWm\u001e)bgN<xN\u001d3\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002NQA\u0011\u0011BA(\u0003#\n\u0019\u0006\u0003\u0004j\u0003\u0017\u0002\rA\u001b\u0005\b\u0003\u0013\nY\u00051\u0001k\u0011\u001d\t)&a\u0013A\u0002)\f1b\u001c7e!\u0006\u001c8o^8sI\"9\u0011\u0011\f\u0001\u0005B\u0005m\u0013A\u00023fY\u0016$X\r\u0006\u0003\u0002\n\u0005u\u0003BB5\u0002X\u0001\u0007!\u000eC\u0004\u0002b\u0001!\t%a\u0019\u0002\r\r\u0014X-\u0019;f)\u0019\tI!!\u001a\u0002h!1\u0011.a\u0018A\u0002)Dq!!\u0010\u0002`\u0001\u0007!\u000eC\u0004\u0002l\u0001!\t%!\u001c\u0002\u001b1L7\u000f^+tKJt\u0017-\\3t)\t\ty\u0007E\u0003\u0002r\u0005]$.\u0004\u0002\u0002t)\u0019\u0011Q\u000f\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\n\u0019H\u0001\u0003MSN$\bbBA6\u0001\u0011\u0005\u0013Q\u0010\u000b\t\u0003_\ny(!!\u0002\u001a\"1\u0011.a\u001fA\u0002)D\u0001\"a!\u0002|\u0001\u0007\u0011QQ\u0001\u0007a\u0006<\u0017N\\4\u0011\t\u0005\u001d\u0015QS\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u0006\u0019A\r^8\u000b\t\u0005=\u0015\u0011S\u0001\u0004CBL'bAAJ\r\u00051QM\\4j]\u0016LA!a&\u0002\n\n1\u0001+Y4j]\u001eD\u0001\"a'\u0002|\u0001\u0007\u0011QT\u0001\u0006_J$WM\u001d\t\u0005\u0003\u000f\u000by*\u0003\u0003\u0002\"\u0006%%\u0001C(sI\u0016\u0014\u0018N\\4)\r\u0001\t)kSAZ!\u0011\t9+a,\u000e\u0005\u0005%&b\u0001#\u0002,*\u0019\u0011QV\u0014\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003c\u000bIKA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0011\u0003\u0003k\u000ba#\\1j]R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\b\u0001\u0005e\u0016qYAe!\u0011\tY,a1\u000e\u0005\u0005u&b\u0001#\u0002@*\u0019\u0011\u0011Y\u0014\u0002\u000f\r|g\u000e^3yi&!\u0011QYA_\u0005\u0015\u00196m\u001c9f\u0003%\u0001(o\u001c=z\u001b>$W\r\n\u0002\u0002L&!\u0011QZAh\u00031!\u0016IU$F)~\u001bE*Q*T\u0015\u0011\t\t.!0\u0002\u001fM\u001bw\u000e]3e!J|\u00070_'pI\u0016D3\u0001AAk!\u0011\t9.!8\u000e\u0005\u0005e'bAAnO\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0017\u0011\u001c\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String SELECT;
    private final String SELECT_NAMES;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private Object withUsernameFilter(String username, SelectBuilder builder) {
        return username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username.toLowerCase()})))) : BoxedUnit.UNIT;
    }

    public long countUsers(String username) {
        SelectBuilder builder = new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)SqlFunction$.MODULE$.countAll());
        this.withUsernameFilter(username, builder);
        return BoxesRunTime.unboxToLong((Object)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new SingleColumnRowMapper(Long.TYPE))).head());
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private Option<InternalUser> readUser(String username) {
        return ((TraversableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).map((Function1 & Serializable & scala.Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())), Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such user: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authenticate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong credentials supplied for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, username, newPassword, oldPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        this.withUsernameFilter(username, builder);
        Object object = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object2 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())) : OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())))) : BoxedUnit.UNIT;
        List names = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new package.MapRowMapper())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()), Buffer$.MODULE$.canBuildFrom())).toList();
        return new ArrayList<String>(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)names));
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String username$4, String newPassword$1, String oldPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
    }
}

