/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.spring.Setter;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import com.xebialabs.deployit.security.sql.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\f\u0019\u0001\rB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005m!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0007i\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000fM\u0004!\u0019!C\u0001i\"1\u0001\u0010\u0001Q\u0001\nUDQ!\u001f\u0001\u0005\niDq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\tY\b\u0001C!\u0003{Bq!a\u001f\u0001\t\u0003\n)\tC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAO\u0001\u0011\u0005\u0013Q\u0016\u0002\u000f'FdWk]3s'\u0016\u0014h/[2f\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u0011M,7-\u001e:jifT!!\b\u0010\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\b\u0011\u0002\u0013a,'-[1mC\n\u001c(\"A\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001!C\u0006\r\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019y%M[3diB\u0011QFL\u0007\u00025%\u0011qF\u0007\u0002\f+N,'oU3sm&\u001cW\r\u0005\u00022e5\t\u0001$\u0003\u000241\tYQk]3s#V,'/[3t\u00031QGMY2UK6\u0004H.\u0019;f+\u00051\u0004CA\u001cA\u001b\u0005A$BA\u001d;\u0003\u0011\u0019wN]3\u000b\u0005mb\u0014\u0001\u00026eE\u000eT!!\u0010 \u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aP\u0001\u0004_J<\u0017BA!9\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005)Ro]3s!J|g-\u001b7f%\u0016\u0004xn]5u_JLX#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!S\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!j\u0012\u0002\u001912$Wk]3s!J|g-\u001b7f%\u0016\u0004xn]5u_JL\u0018AF;tKJ\u0004&o\u001c4jY\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001O!\ty%+D\u0001Q\u0015\tI\u0012K\u0003\u0002:9%\u00111\u000b\u0015\u0002\u000b'FdG)[1mK\u000e$\u0018aC:rY\u0012K\u0017\r\\3di\u0002\na\u0001P5oSRtDcA,mcR\u0011\u0001,\u0017\t\u0003c\u0001AQ\u0001T\u0004A\u00049CC!W.fMB\u0011AlY\u0007\u0002;*\u0011alX\u0001\u000bC:tw\u000e^1uS>t'B\u00011b\u0003\u001d1\u0017m\u0019;pefT!A\u0019\u001f\u0002\u000b\t,\u0017M\\:\n\u0005\u0011l&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00059\u0017AD7bS:\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0015\u00033&\u0004\"\u0001\u00186\n\u0005-l&!C!vi><\u0018N]3e\u0011\u0015!t\u00011\u00017Q\u0011a7,\u001a8\"\u0003=\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3)\u00051L\u0007\"B\"\b\u0001\u0004)\u0005FA9j\u0003=\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014X#A;\u0011\u000552\u0018BA<\u001b\u0005U\u0019\u0006*\u0011\u001a6mA\u000b7o]<pe\u0012,enY8eKJ\f\u0001\u0003]1tg^|'\u000fZ#oG>$WM\u001d\u0011\u0002%]LG\u000f[+tKJt\u0017-\\3GS2$XM\u001d\u000b\u0006w\u0006\r\u0011Q\u0004\t\u0003y~l\u0011! \u0006\u0002}\u0006)1oY1mC&\u0019\u0011\u0011A?\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0006)\u0001\r!a\u0002\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004B!!\u0003\u0002\u00189!\u00111BA\n!\r\ti!`\u0007\u0003\u0003\u001fQ1!!\u0005#\u0003\u0019a$o\\8u}%\u0019\u0011QC?\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)\" \u0005\b\u0003?Q\u0001\u0019AA\u0011\u0003\u001d\u0011W/\u001b7eKJ\u00042aTA\u0012\u0013\r\t)\u0003\u0015\u0002\u000e'\u0016dWm\u0019;Ck&dG-\u001a:\u0002\u0015\r|WO\u001c;Vg\u0016\u00148\u000f\u0006\u0003\u0002,\u0005E\u0002c\u0001?\u0002.%\u0019\u0011qF?\u0003\t1{gn\u001a\u0005\b\u0003\u000bY\u0001\u0019AA\u0004Q\u0019Y\u0011QG3\u0002<A\u0019Q%a\u000e\n\u0007\u0005ebE\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg2\u0012\u0011QH\u0011\u0003\u0003\u007f\t1!\u00197m\u0003I\u0019\u0007.Z2l-\u0006d\u0017\u000eZ+tKJt\u0017-\\3\u0015\t\u0005\u0015\u00131\n\t\u0004y\u0006\u001d\u0013bAA%{\n!QK\\5u\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000f\t!c\u00195fG.\fE-\\5o+N,'O\\1nKR!\u0011QIA)\u0011\u001d\t)!\u0004a\u0001\u0003\u000f\t\u0001B]3bIV\u001bXM\u001d\u000b\u0005\u0003/\n\u0019\u0007E\u0003}\u00033\ni&C\u0002\u0002\\u\u0014aa\u00149uS>t\u0007cA\u0019\u0002`%\u0019\u0011\u0011\r\r\u0003\u0019%sG/\u001a:oC2,6/\u001a:\t\u000f\u0005\u0015a\u00021\u0001\u0002\b\u0005!!/Z1e)\u0011\tI'a\u001c\u0011\u00075\nY'C\u0002\u0002ni\u0011A!V:fe\"9\u0011QA\bA\u0002\u0005\u001d\u0011\u0001D1vi\",g\u000e^5dCR,GCBA#\u0003k\n9\bC\u0004\u0002\u0006A\u0001\r!a\u0002\t\u000f\u0005e\u0004\u00031\u0001\u0002\b\u0005A\u0001/Y:to>\u0014H-\u0001\bn_\u0012Lg-\u001f)bgN<xN\u001d3\u0015\r\u0005\u0015\u0013qPAA\u0011\u001d\t)!\u0005a\u0001\u0003\u000fAq!a!\u0012\u0001\u0004\t9!A\u0006oK^\u0004\u0016m]:x_J$G\u0003CA#\u0003\u000f\u000bI)a#\t\u000f\u0005\u0015!\u00031\u0001\u0002\b!9\u00111\u0011\nA\u0002\u0005\u001d\u0001bBAG%\u0001\u0007\u0011qA\u0001\f_2$\u0007+Y:to>\u0014H-\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u000b\n\u0019\nC\u0004\u0002\u0006M\u0001\r!a\u0002\u0002\r\r\u0014X-\u0019;f)\u0019\t)%!'\u0002\u001c\"9\u0011Q\u0001\u000bA\u0002\u0005\u001d\u0001bBA=)\u0001\u0007\u0011qA\u0001\u000eY&\u001cH/V:fe:\fW.Z:\u0015\u0005\u0005\u0005\u0006CBAR\u0003S\u000b9!\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\u000b)K\u0001\u0003MSN$H\u0003CAQ\u0003_\u000b\t,!3\t\u000f\u0005\u0015a\u00031\u0001\u0002\b!9\u00111\u0017\fA\u0002\u0005U\u0016A\u00029bO&tw\r\u0005\u0003\u00028\u0006\u0015WBAA]\u0015\u0011\tY,!0\u0002\u0007\u0011$xN\u0003\u0003\u0002@\u0006\u0005\u0017aA1qS*\u0019\u00111\u0019\u000f\u0002\r\u0015tw-\u001b8f\u0013\u0011\t9-!/\u0003\rA\u000bw-\u001b8h\u0011\u001d\tYM\u0006a\u0001\u0003\u001b\fQa\u001c:eKJ\u0004B!a.\u0002P&!\u0011\u0011[A]\u0005!y%\u000fZ3sS:<\u0007F\u0002\u0001\u0002V\u0016\f\u0019\u000f\u0005\u0003\u0002X\u0006}WBAAm\u0015\rq\u00161\u001c\u0006\u0004\u0003;d\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!9\u0002Z\niAK]1og\u0006\u001cG/[8oC2\f#!!:\u0002-5\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJDs\u0001AAu\u0003o\fI\u0010\u0005\u0003\u0002l\u0006MXBAAw\u0015\rq\u0016q\u001e\u0006\u0004\u0003cd\u0014aB2p]R,\u0007\u0010^\u0005\u0005\u0003k\fiOA\u0003TG>\u0004X-A\u0005qe>D\u00180T8eK\u0012\u0012\u00111`\u0005\u0005\u0003{\fy0\u0001\u0007U\u0003J;U\tV0D\u0019\u0006\u001b6K\u0003\u0003\u0003\u0002\u00055\u0018aD*d_B,G\r\u0015:pqflu\u000eZ3)\u0007\u0001\u0011)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\r\u0011Y\u0001P\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B\b\u0005\u0013\u0011\u0011bQ8na>tWM\u001c;")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final XldUserProfileRepository userProfileRepository;
    private final SqlDialect sqlDialect;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String SELECT;
    private final String SELECT_NAMES;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public XldUserProfileRepository userProfileRepository() {
        return this.userProfileRepository;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private Object withUsernameFilter(String username, SelectBuilder builder) {
        return username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringBuilder(2).append("%").append(username.toLowerCase()).append("%").toString())) : BoxedUnit.UNIT;
    }

    public long countUsers(String username) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)SqlFunction$.MODULE$.countAll());
        this.withUsernameFilter(username, builder);
        return BoxesRunTime.unboxToLong((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new SingleColumnRowMapper(Long.TYPE))).asScala()).head());
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private void checkAdminUsername(String username) {
        if ("admin".equalsIgnoreCase(username)) {
            throw new IllegalArgumentException("Admin user cannot be deleted.");
        }
    }

    private Option<InternalUser> readUser(String username) {
        return ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).asScala()).map((Function1 & Serializable & scala.Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())), Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(14).append("No such user: ").append(username).toString(), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringBuilder(20).append("Cannot authenticate ").append(username).toString());
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringBuilder(36).append("Wrong credentials supplied for user ").append(username).toString());
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.checkAdminUsername(username);
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
        this.userProfileRepository().delete(username);
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
        this.userProfileRepository().createProfile(username);
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        this.withUsernameFilter(username, builder);
        Object object = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object2 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())) : OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())))) : BoxedUnit.UNIT;
        List names = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)package.MapRowMapper$.MODULE$)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        return package$.MODULE$.asMutableJavaList(names);
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String oldPassword$1, String username$4, String newPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired XldUserProfileRepository userProfileRepository, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.userProfileRepository = userProfileRepository;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
    }
}

