/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.artifacts;

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactQueries;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactUsageQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005g!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!b\u0001\n\u0007Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000bA\u0004A\u0011I9\t\u000by\u0004A\u0011I@\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA%\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\tI\b\u0001C!\u0003wBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\nABIY!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\u000b\u0005Q)\u0012!C1si&4\u0017m\u0019;t\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001b7\u0005AA-\u001a9m_fLGO\u0003\u0002\u001d;\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M)\u0001!I\u0014,]A\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0015\u000e\u0003MI!AK\n\u0003-\u0005\u0013H/\u001b4bGR$\u0015\r^1SKB|7/\u001b;pef\u0004\"\u0001\u000b\u0017\n\u00055\u001a\"!\u0005#c\u0003J$\u0018NZ1diF+XM]5fgB\u0011\u0001fL\u0005\u0003aM\u0011a\u0003\u00122BeRLg-Y2u+N\fw-Z)vKJLWm]\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0002gA\u0011A'P\u0007\u0002k)\u0011agN\u0001\u0005G>\u0014XM\u0003\u00029s\u0005!!\u000e\u001a2d\u0015\tQ4(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0014aA8sO&\u0011a(\u000e\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u00023\rDWmY6tk6\fEnZ8sSRDW\u000e\u0015:pm&$WM]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q)G\u0001\tG\",7m[:v[&\u0011q\t\u0012\u0002\u001a\u0007\",7m[:v[\u0006cwm\u001c:ji\"l\u0007K]8wS\u0012,'/\u0001\u000edQ\u0016\u001c7n];n\u00032<wN]5uQ6\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0006tc2$\u0015.\u00197fGR,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003-9S!AN\r\n\u0005Ak%AC*rY\u0012K\u0017\r\\3di\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0019A+\u001b8\u0015\u0005U3\u0006C\u0001\u0015\u0001\u0011\u0015Iu\u0001q\u0001LQ\u00111\u0006LY2\u0011\u0005e\u0003W\"\u0001.\u000b\u0005mc\u0016AC1o]>$\u0018\r^5p]*\u0011QLX\u0001\bM\u0006\u001cGo\u001c:z\u0015\ty\u0016(A\u0003cK\u0006t7/\u0003\u0002b5\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002I\u0006qQ.Y5o'FdG)[1mK\u000e$\bF\u0001,g!\tIv-\u0003\u0002i5\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006c\u001d\u0001\ra\r\u0015\u0005Sb\u00137.I\u0001m\u0003Ai\u0017-\u001b8KI\n\u001cG+Z7qY\u0006$X\r\u000b\u0002jM\")\u0001i\u0002a\u0001\u0005\"\u0012aNZ\u0001\u0010e\u00164gI]8n\u0007\",7m[:v[R\u0011!/ \t\u0003gjt!\u0001\u001e=\u0011\u0005U\u001cS\"\u0001<\u000b\u0005]|\u0012A\u0002\u001fs_>$h(\u0003\u0002zG\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tI8\u0005C\u0003F\u0011\u0001\u0007!/A\u0003ti>\u0014X\r\u0006\u0004\u0002\u0002\u0005\u001d\u0011Q\u0007\t\u0004E\u0005\r\u0011bAA\u0003G\t!QK\\5u\u0011\u001d\tI!\u0003a\u0001\u0003\u0017\t!\u0001]6\u0011\t\u00055\u0011q\u0006\b\u0005\u0003\u001f\tIC\u0004\u0003\u0002\u0012\u0005\u0015b\u0002BA\n\u0003GqA!!\u0006\u0002\"9!\u0011qCA\u0010\u001d\u0011\tI\"!\b\u000f\u0007U\fY\"C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I1!a\n\u0016\u0003\u0011\u0011\u0017m]3\n\t\u0005-\u0012QF\u0001\ba\u0006\u001c7.Y4f\u0015\r\t9#F\u0005\u0005\u0003c\t\u0019D\u0001\u0005DSB[E+\u001f9f\u0015\u0011\tY#!\f\t\u000f\u0005]\u0012\u00021\u0001\u0002:\u0005Y\u0011N\u001c9viN#(/Z1n!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n!![8\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002>\tY\u0011J\u001c9viN#(/Z1n\u0003\u0019Ign]3siR1\u0011QJA*\u0003/\u00022AIA(\u0013\r\t\tf\t\u0002\u0004\u0013:$\bBBA+\u0015\u0001\u0007!/\u0001\u0002jI\"9\u0011q\u0007\u0006A\u0002\u0005e\u0012AB3ySN$8\u000f\u0006\u0003\u0002^\u0005\r\u0004c\u0001\u0012\u0002`%\u0019\u0011\u0011M\u0012\u0003\u000f\t{w\u000e\\3b]\"1\u0011QK\u0006A\u0002I$b!!\u0001\u0002h\u0005%\u0004bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\u0007\u0003Wb\u0001\u0019\u0001:\u0002\u0013I,g-\u001a:f]\u000e,\u0017\u0001B2paf$b!!\u0001\u0002r\u0005U\u0004BBA:\u001b\u0001\u0007!/\u0001\u0004ge>l\u0017\n\u001a\u0005\b\u0003oj\u0001\u0019AA\u0006\u0003\u0011!x\u000eU6\u0002\u0011I,GO]5fm\u0016$B!!\u000f\u0002~!1\u0011Q\u000b\bA\u0002I\fa\u0001Z3mKR,G\u0003BA\u0001\u0003\u0007Cq!!\u0003\u0010\u0001\u0004\tY!\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003\u0003\tI\t\u0003\u0004\u0002\fB\u0001\rA]\u0001\u000bCJ$\u0018NZ1di&#\u0017AD2pk:$\u0018I\u001d;jM\u0006\u001cGo]\u000b\u0003\u0003\u001bB3\u0001AAJ!\u0011\t)*a'\u000e\u0005\u0005]%bAAMs\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005u\u0015q\u0013\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DbArtifactDataRepository
implements ArtifactDataRepository,
DbArtifactQueries,
DbArtifactUsageQueries {
    private final JdbcTemplate jdbcTemplate;
    private final ChecksumAlgorithmProvider checksumAlgorithmProvider;
    private final SqlDialect sqlDialect;
    private final String INSERT_USAGE;
    private final String COPY_USAGE;
    private final String SELECT_ARTIFACT_BY_USAGE;
    private final String COUNT_USAGE;
    private final String DELETE_USAGE;
    private final String COUNT_ALL_ARTIFACTS;
    private final String INSERT_ARTIFACT;
    private final String UPDATE_ARTIFACT_ID;
    private final String COUNT_ARTIFACT_BY_ID;
    private final String SELECT_ARTIFACT_BY_PATH;
    private final String DELETE_ARTIFACT;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String INSERT_USAGE() {
        return this.INSERT_USAGE;
    }

    @Override
    public String COPY_USAGE() {
        return this.COPY_USAGE;
    }

    @Override
    public String SELECT_ARTIFACT_BY_USAGE() {
        return this.SELECT_ARTIFACT_BY_USAGE;
    }

    @Override
    public String COUNT_USAGE() {
        return this.COUNT_USAGE;
    }

    @Override
    public String DELETE_USAGE() {
        return this.DELETE_USAGE;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$INSERT_USAGE_$eq(String x$1) {
        this.INSERT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COPY_USAGE_$eq(String x$1) {
        this.COPY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$SELECT_ARTIFACT_BY_USAGE_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COUNT_USAGE_$eq(String x$1) {
        this.COUNT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$DELETE_USAGE_$eq(String x$1) {
        this.DELETE_USAGE = x$1;
    }

    @Override
    public String COUNT_ALL_ARTIFACTS() {
        return this.COUNT_ALL_ARTIFACTS;
    }

    @Override
    public String INSERT_ARTIFACT() {
        return this.INSERT_ARTIFACT;
    }

    @Override
    public String UPDATE_ARTIFACT_ID() {
        return this.UPDATE_ARTIFACT_ID;
    }

    @Override
    public String COUNT_ARTIFACT_BY_ID() {
        return this.COUNT_ARTIFACT_BY_ID;
    }

    @Override
    public String SELECT_ARTIFACT_BY_PATH() {
        return this.SELECT_ARTIFACT_BY_PATH;
    }

    @Override
    public String DELETE_ARTIFACT() {
        return this.DELETE_ARTIFACT;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ALL_ARTIFACTS_$eq(String x$1) {
        this.COUNT_ALL_ARTIFACTS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$INSERT_ARTIFACT_$eq(String x$1) {
        this.INSERT_ARTIFACT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$UPDATE_ARTIFACT_ID_$eq(String x$1) {
        this.UPDATE_ARTIFACT_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ARTIFACT_BY_ID_$eq(String x$1) {
        this.COUNT_ARTIFACT_BY_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$SELECT_ARTIFACT_BY_PATH_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_PATH = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$DELETE_ARTIFACT_$eq(String x$1) {
        this.DELETE_ARTIFACT = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ChecksumAlgorithmProvider checksumAlgorithmProvider() {
        return this.checksumAlgorithmProvider;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public String refFromChecksum(String checksum) {
        return checksum;
    }

    @Override
    public void store(Integer pk, InputStream inputStream) {
        Object object;
        MessageDigest digest = this.checksumAlgorithmProvider().getMessageDigest();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);
        String tempArtifactId = UUID.randomUUID().toString();
        this.insert(tempArtifactId, digestInputStream);
        String checksum = JavaCryptoUtils.digest((MessageDigest)digest);
        if (this.exists(checksum)) {
            this.remove(tempArtifactId);
            object = BoxedUnit.UNIT;
        } else {
            object = BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.UPDATE_ARTIFACT_ID(), new Object[]{checksum, tempArtifactId}));
        }
        this.insert(pk, checksum);
    }

    public int insert(String id, InputStream inputStream) {
        return this.jdbcTemplate().update(this.INSERT_ARTIFACT(), ps -> {
            ps.setString(1, id);
            ps.setBinaryStream(2, inputStream);
        });
    }

    public boolean exists(String id) {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ARTIFACT_BY_ID(), Number.class, new Object[]{id})).intValue() > 0;
    }

    @Override
    public void insert(Integer pk, String reference) {
        this.jdbcTemplate().update(this.INSERT_USAGE(), new Object[]{pk, reference});
    }

    @Override
    public void copy(String fromId, Integer toPk) {
        this.jdbcTemplate().update(this.COPY_USAGE(), new Object[]{toPk, fromId});
    }

    @Override
    public InputStream retrieve(String id) {
        return new InputStream(this, id){
            private final Connection con;
            private final PreparedStatement ps;
            private final ResultSet rs;
            private final InputStream delegate;
            private final /* synthetic */ DbArtifactDataRepository $outer;

            private Connection con() {
                return this.con;
            }

            private PreparedStatement ps() {
                return this.ps;
            }

            private ResultSet rs() {
                return this.rs;
            }

            private InputStream delegate() {
                return this.delegate;
            }

            public int read() {
                return this.delegate().read();
            }

            public int read(byte[] b, int off, int len) {
                return this.delegate().read(b, off, len);
            }

            public void close() {
                JdbcUtils.closeResultSet((ResultSet)this.rs());
                JdbcUtils.closeStatement((Statement)this.ps());
                DataSourceUtils.releaseConnection((Connection)this.con(), (DataSource)this.$outer.jdbcTemplate().getDataSource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.con = DataSourceUtils.getConnection((DataSource)$outer.jdbcTemplate().getDataSource());
                this.ps = this.con().prepareStatement($outer.SELECT_ARTIFACT_BY_PATH());
                this.ps().setString(1, package$.MODULE$.idToPath(id$2));
                this.rs = this.ps().executeQuery();
                if (!this.rs().next()) {
                    throw new NotFoundException(new StringBuilder(29).append("Artifact data not found for: ").append(id$2).toString(), new Object[0]);
                }
                this.delegate = this.rs().getBinaryStream(1);
            }
        };
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().queryForList(this.SELECT_ARTIFACT_BY_USAGE(), String.class, new Object[]{pk}).forEach(artifactId -> {
            block0: {
                int count = ((Number)this.jdbcTemplate().queryForObject(this.COUNT_USAGE(), Number.class, new Object[]{artifactId})).intValue();
                Object object = count > 0 ? BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.DELETE_USAGE(), new Object[]{pk})) : BoxedUnit.UNIT;
                if (count != 1) break block0;
                this.remove((String)artifactId);
            }
        });
    }

    public void remove(String artifactId) {
        this.jdbcTemplate().update(this.DELETE_ARTIFACT(), new Object[]{artifactId});
    }

    @Override
    public int countArtifacts() {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ALL_ARTIFACTS(), Number.class)).intValue();
    }

    public DbArtifactDataRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired ChecksumAlgorithmProvider checksumAlgorithmProvider, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        DbArtifactQueries.$init$(this);
        DbArtifactUsageQueries.$init$(this);
    }
}

