/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.sql.placeholders.SqlPlaceholderRepository;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001=\u0011QBU3oC6,7i\\7nC:$'BA\u0002\u0005\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\t!B]3q_NLGo\u001c:z\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\t\f\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!AG\u000e\u0002\t\r|'/\u001a\u0006\u00039u\tAA\u001b3cG*\u0011adH\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\tQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002%\u0005\u0014H/\u001b4bGR\u0014V\r]8tSR|'/\u001f\t\u0003Q-j\u0011!\u000b\u0006\u0003U\u0011\t\u0011\"\u0019:uS\u001a\f7\r^:\n\u00051J#AF!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\t\u00119\u0002!\u0011!Q\u0001\n=\nQ\u0003\u001d7bG\u0016Dw\u000e\u001c3feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u00023\t\u0005a\u0001\u000f\\1dK\"|G\u000eZ3sg&\u0011A'\r\u0002\u0019'Fd\u0007\u000b\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\b\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\u0002\u0013I,g.Y7f\u0007&\u001cX#\u0001\u001d\u0011\u0007e\u001aeI\u0004\u0002;\u0001:\u00111HP\u0007\u0002y)\u0011QHD\u0001\u0007yI|w\u000e\u001e \n\u0003}\nQa]2bY\u0006L!!\u0011\"\u0002\u000fA\f7m[1hK*\tq(\u0003\u0002E\u000b\nA\u0011\n^3sC\ndWM\u0003\u0002B\u0005B!qI\u0013'M\u001b\u0005A%BA%\t\u0003\u0011)H/\u001b7\n\u0005-C%!\u0002+va2,\u0007CA'R\u001d\tqu\n\u0005\u0002<\u0005&\u0011\u0001KQ\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u0005\"AQ\u000b\u0001B\u0001B\u0003%\u0001(\u0001\u0006sK:\fW.Z\"jg\u0002B\u0001b\u0016\u0001\u0003\u0006\u0004%\u0019\u0001W\u0001\u000bgFdG)[1mK\u000e$X#A-\u0011\u0005ikV\"A.\u000b\u0005\u0015a&B\u0001\u000e\t\u0013\tq6L\u0001\u0006Tc2$\u0015.\u00197fGRD\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!W\u0001\fgFdG)[1mK\u000e$\b\u0005C\u0003c\u0001\u0011\u00051-\u0001\u0004=S:LGO\u0010\u000b\u0006I\u001eD\u0017N\u001b\u000b\u0003K\u001a\u0004\"!\u0005\u0001\t\u000b]\u000b\u00079A-\t\u000bU\t\u0007\u0019A\f\t\u000b\u0019\n\u0007\u0019A\u0014\t\u000b9\n\u0007\u0019A\u0018\t\u000bY\n\u0007\u0019\u0001\u001d\t\u000b1\u0004A\u0011I7\u0002\u000f\u0015DXmY;uKR\u0011aN\u001d\t\u0003_Bl\u0011AQ\u0005\u0003c\n\u0013A!\u00168ji\")1o\u001ba\u0001i\u000691m\u001c8uKb$\bCA\tv\u0013\t1(A\u0001\tDQ\u0006tw-Z*fi\u000e{g\u000e^3yi\")\u0001\u0010\u0001C!s\u0006Aa/\u00197jI\u0006$X\r\u0006\u0002ou\")1o\u001ea\u0001i\")A\u0010\u0001C\u0005{\u00061!/\u001a8b[\u0016$BA\u001c@\u0002\u0002!)qp\u001fa\u0001\u0019\u0006)q\u000e\u001c3JI\"1\u00111A>A\u00021\u000bqA\\3x\u001d\u0006lW\rC\u0004\u0002\b\u0001!I!!\u0003\u0002\u001dY\fG.\u001b3bi\u0016\u0014VM\\1nKR)a.a\u0003\u0002\u000e!1q0!\u0002A\u00021Cq!a\u0001\u0002\u0006\u0001\u0007A\nC\u0004\u0002\u0012\u0001!I!a\u0005\u0002'E,XM]=B]\u0012\u0004&/\u001a,bY&$\u0017\r^3\u0015\r\u0005U\u0011QGA\u001c!\u0019y\u0017q\u0003'\u0002\u001c%\u0019\u0011\u0011\u0004\"\u0003\rQ+\b\u000f\\33!\u001d\ti\"!\nM\u0003Si!!a\b\u000b\u0007%\u000b\tC\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#a\b\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\u0011\ty#!\t\u0002\t1\fgnZ\u0005\u0005\u0003g\tiC\u0001\u0004PE*,7\r\u001e\u0005\u0007\u007f\u0006=\u0001\u0019\u0001'\t\u000f\u0005\r\u0011q\u0002a\u0001\u0019\u0002")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> renameCis() {
        return this.renameCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName);
        EventBusHolder.publish((Object)new CiRenamedEvent(package$.MODULE$.readBaseCiFromMap(map3), newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName;
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!new StringOps(Predef$.MODULE$.augmentString(newName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/')) ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, SqlPlaceholderRepository placeholderRepository, Iterable<Tuple<String, String>> renameCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, placeholderRepository);
    }
}

