/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001=\u00111\"T8wK\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tVa\u0012\fG/\u001a)bi\"\u001cu.\\7b]\u0012\u0004\"!E\u000b\n\u0005Y\u0011!\u0001E\"j!\u0006$\bNV1mS\u0012\fG/[8o\u0011!A\u0002A!b\u0001\n\u0003J\u0012\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012\u0001B2pe\u0016T!a\b\u0011\u0002\t)$'m\u0019\u0006\u0003C\t\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015b\"\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!I\u0003A!A!\u0002\u0013Q\u0013AF1si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011!C1si&4\u0017m\u0019;t\u0013\tyCF\u0001\fBeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001E2p[6\fg\u000e\u001a,bY&$\u0017\r^8s!\t\u0019d'D\u00015\u0015\t)d!\u0001\u0006wC2LG-\u0019;j_:L!a\u000e\u001b\u0003!\r{W.\\1oIZ\u000bG.\u001b3bi>\u0014\b\u0002C\u001d\u0001\u0005\u000b\u0007I\u0011\u0001\u001e\u0002\u000f5|g/Z\"jgV\t1\bE\u0002=\r&s!!P\"\u000f\u0005y\nU\"A \u000b\u0005\u0001s\u0011A\u0002\u001fs_>$h(C\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!U)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\tK!a\u0012%\u0003\u0011%#XM]1cY\u0016T!\u0001R#\u0011\t)kujT\u0007\u0002\u0017*\u0011A\nC\u0001\u0005kRLG.\u0003\u0002O\u0017\n)A+\u001e9mKB\u0011\u0001\u000b\u0016\b\u0003#J\u0003\"AP#\n\u0005M+\u0015A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU#\t\u0011a\u0003!\u0011!Q\u0001\nm\n\u0001\"\\8wK\u000eK7\u000f\t\u0005\t5\u0002\u0011)\u0019!C\u00027\u0006Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!!B0\u000b\u0005uA\u0011BA1_\u0005)\u0019\u0016\u000f\u001c#jC2,7\r\u001e\u0005\tG\u0002\u0011\t\u0011)A\u00059\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0019a\u0014N\\5u}Q)qM[6m[R\u0011\u0001.\u001b\t\u0003#\u0001AQA\u00173A\u0004qCQ\u0001\u00073A\u0002iAQ!\u000b3A\u0002)BQ!\r3A\u0002IBQ!\u000f3A\u0002mBQa\u001c\u0001\u0005BA\fq!\u001a=fGV$X\r\u0006\u0002rkB\u0011!o]\u0007\u0002\u000b&\u0011A/\u0012\u0002\u0005+:LG\u000fC\u0003w]\u0002\u0007q/A\u0004d_:$X\r\u001f;\u0011\u0005EA\u0018BA=\u0003\u0005A\u0019\u0005.\u00198hKN+GoQ8oi\u0016DH\u000fC\u0003|\u0001\u0011\u0005C0\u0001\u0005wC2LG-\u0019;f)\t\tX\u0010C\u0003wu\u0002\u0007q\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001\u0005[>4X\rF\u0004r\u0003\u0007\t9!a\u0003\t\r\u0005\u0015a\u00101\u0001P\u0003\u0015yG\u000eZ%e\u0011\u0019\tIA a\u0001\u001f\u0006)a.Z<JI\")aO a\u0001o\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0011aE9vKJL\u0018I\u001c3Qe\u00164\u0016\r\\5eCR,G\u0003CA\n\u0003g\t)$a\u000e\u0011\rI\f)bTA\r\u0013\r\t9\"\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000f\u0005m\u00111E(\u0002(5\u0011\u0011Q\u0004\u0006\u0004\u0019\u0006}!BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0012Q\u0004\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0015\u0003_i!!a\u000b\u000b\t\u00055\u0012qD\u0001\u0005Y\u0006tw-\u0003\u0003\u00022\u0005-\"AB(cU\u0016\u001cG\u000fC\u0004\u0002\u0006\u00055\u0001\u0019A(\t\u000f\u0005%\u0011Q\u0002a\u0001\u001f\"1a/!\u0004A\u0002]Dq!a\u000f\u0001\t\u0013\ti$\u0001\u0007wC2LG-\u0019;f\u001b>4X\rF\u0004r\u0003\u007f\t\t%a\u0011\t\u000f\u0005\u0015\u0011\u0011\ba\u0001\u001f\"9\u0011\u0011BA\u001d\u0001\u0004y\u0005B\u0002<\u0002:\u0001\u0007q\u000f")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation {
    private final JdbcTemplate jdbcTemplate;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> moveCis() {
        return this.moveCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, package$.MODULE$.idToPath(newId));
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block5: {
            Tuple2<String, Map<String, Object>> tuple2;
            block4: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block4;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block4;
                string = oldPath;
                if (map != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactDataRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactDataRepository);
        CiPathValidation.$init$(this);
    }
}

