/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.artifacts;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactQueries;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactUsageQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001=\u0011A\u0003\u00122BeRLg-Y2u%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003%\t'\u000f^5gC\u000e$8O\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0011BC\u0001\tI\u0016\u0004Hn\\=ji*\u00111\u0002D\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!D\u0001\u0004G>l7\u0001A\n\u0006\u0001A1\"$\b\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!AE!si&4\u0017m\u0019;SKB|7/\u001b;pef\u0004\"aF\u000e\n\u0005q\u0011!!\u0005#c\u0003J$\u0018NZ1diF+XM]5fgB\u0011qCH\u0005\u0003?\t\u0011a\u0003\u00122BeRLg-Y2u+N\fw-Z)vKJLWm\u001d\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t1\u0005\u0005\u0002%[5\tQE\u0003\u0002'O\u0005!1m\u001c:f\u0015\tA\u0013&\u0001\u0003kI\n\u001c'B\u0001\u0016,\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/K\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"A\u0001\u0007\u0001B\u0001B\u0003%1%A\u0007kI\n\u001cG+Z7qY\u0006$X\r\t\u0005\te\u0001\u0011)\u0019!C\u0002g\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR!!B\u001c\u000b\u0005\u0019B\u0011BA\u001d7\u0005)\u0019\u0016\u000f\u001c#jC2,7\r\u001e\u0005\tw\u0001\u0011\t\u0011)A\u0005i\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q\u0011q\b\u0016\u000b\u0003\u0001\u0006\u0003\"a\u0006\u0001\t\u000bIb\u00049\u0001\u001b)\t\u0005\u001bUJ\u0014\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000b!\"\u00198o_R\fG/[8o\u0015\tA\u0015*A\u0004gC\u000e$xN]=\u000b\u0005)K\u0013!\u00022fC:\u001c\u0018B\u0001'F\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001P\u00039i\u0017-\u001b8Tc2$\u0015.\u00197fGRD#!Q)\u0011\u0005\u0011\u0013\u0016BA*F\u0005%\tU\u000f^8xSJ,G\rC\u0003\"y\u0001\u00071\u0005\u000b\u0003U\u000763\u0016%A,\u0002!5\f\u0017N\u001c&eE\u000e$V-\u001c9mCR,\u0007F\u0001+R\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003=\u0011XM\u001a$s_6\u001c\u0005.Z2lgVlGC\u0001/h!\tiFM\u0004\u0002_EB\u0011qLE\u0007\u0002A*\u0011\u0011MD\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019\n\t\u000b!L\u0006\u0019\u0001/\u0002\u0011\rDWmY6tk6DQA\u001b\u0001\u0005B-\fQa\u001d;pe\u0016$b\u0001\\8\u0002\u000e\u0005E\u0001CA\tn\u0013\tq'C\u0001\u0003V]&$\b\"\u00029j\u0001\u0004\t\u0018A\u00019l!\r\u0011\u0018q\u0001\b\u0004g\u0006\u0005aB\u0001;\u007f\u001d\t)XP\u0004\u0002wy:\u0011qo\u001f\b\u0003qjt!aX=\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0000\t\u0005!!-Y:f\u0013\u0011\t\u0019!!\u0002\u0002\u000fA\f7m[1hK*\u0011q\u0010B\u0005\u0005\u0003\u0013\tYA\u0001\u0005DSB[E+\u001f9f\u0015\u0011\t\u0019!!\u0002\t\r\u0005=\u0011\u000e1\u0001]\u0003!1\u0017\u000e\\3oC6,\u0007bBA\nS\u0002\u0007\u0011QC\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0005%|'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002(\u0001!\t!!\u000b\u0002\r%t7/\u001a:u)\u0019\tY#!\r\u00026A\u0019\u0011#!\f\n\u0007\u0005=\"CA\u0002J]RDq!a\r\u0002&\u0001\u0007A,\u0001\u0002jI\"A\u00111CA\u0013\u0001\u0004\t)\u0002C\u0004\u0002(\u0001!\t%!\u000f\u0015\u000f1\fY$!\u0010\u0002@!1\u0001/a\u000eA\u0002EDq!a\u0004\u00028\u0001\u0007A\fC\u0004\u0002B\u0005]\u0002\u0019\u0001/\u0002\u0013I,g-\u001a:f]\u000e,\u0007bBA#\u0001\u0011\u0005\u0013qI\u0001\u0005G>\u0004\u0018\u0010F\u0003m\u0003\u0013\ni\u0005C\u0004\u0002L\u0005\r\u0003\u0019\u0001/\u0002\r\u0019\u0014x.\\%e\u0011\u001d\ty%a\u0011A\u0002E\fA\u0001^8QW\"9\u00111\u000b\u0001\u0005B\u0005U\u0013\u0001\u0003:fiJLWM^3\u0015\t\u0005U\u0011q\u000b\u0005\b\u0003g\t\t\u00061\u0001]\u0011\u001d\tY\u0006\u0001C!\u0003;\n1bZ3u\r&dWM\\1nKR\u0019A,a\u0018\t\u000f\u0005M\u0012\u0011\fa\u00019\"9\u00111\r\u0001\u0005B\u0005\u0015\u0014A\u00023fY\u0016$X\rF\u0002m\u0003OBa\u0001]A1\u0001\u0004\t\bf\u0001\u0001\u0002lA!\u0011QNA:\u001b\t\tyGC\u0002\u0002r%\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)(a\u001c\u0003\u0013\r{W\u000e]8oK:$\b")
public class DbArtifactRepository
implements ArtifactRepository,
DbArtifactQueries,
DbArtifactUsageQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final String INSERT_USAGE;
    private final String COPY_USAGE;
    private final String SELECT_USAGE_FILENAME;
    private final String SELECT_ARTIFACT_BY_USAGE;
    private final String COUNT_USAGE;
    private final String DELETE_USAGE;
    private final String INSERT_ARTIFACT;
    private final String UPDATE_ARTIFACT_ID;
    private final String COUNT_ARTIFACT_BY_ID;
    private final String SELECT_ARTIFACT_BY_PATH;
    private final String DELETE_ARTIFACT;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String INSERT_USAGE() {
        return this.INSERT_USAGE;
    }

    @Override
    public String COPY_USAGE() {
        return this.COPY_USAGE;
    }

    @Override
    public String SELECT_USAGE_FILENAME() {
        return this.SELECT_USAGE_FILENAME;
    }

    @Override
    public String SELECT_ARTIFACT_BY_USAGE() {
        return this.SELECT_ARTIFACT_BY_USAGE;
    }

    @Override
    public String COUNT_USAGE() {
        return this.COUNT_USAGE;
    }

    @Override
    public String DELETE_USAGE() {
        return this.DELETE_USAGE;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$INSERT_USAGE_$eq(String x$1) {
        this.INSERT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COPY_USAGE_$eq(String x$1) {
        this.COPY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$SELECT_USAGE_FILENAME_$eq(String x$1) {
        this.SELECT_USAGE_FILENAME = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$SELECT_ARTIFACT_BY_USAGE_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COUNT_USAGE_$eq(String x$1) {
        this.COUNT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$DELETE_USAGE_$eq(String x$1) {
        this.DELETE_USAGE = x$1;
    }

    @Override
    public String INSERT_ARTIFACT() {
        return this.INSERT_ARTIFACT;
    }

    @Override
    public String UPDATE_ARTIFACT_ID() {
        return this.UPDATE_ARTIFACT_ID;
    }

    @Override
    public String COUNT_ARTIFACT_BY_ID() {
        return this.COUNT_ARTIFACT_BY_ID;
    }

    @Override
    public String SELECT_ARTIFACT_BY_PATH() {
        return this.SELECT_ARTIFACT_BY_PATH;
    }

    @Override
    public String DELETE_ARTIFACT() {
        return this.DELETE_ARTIFACT;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$INSERT_ARTIFACT_$eq(String x$1) {
        this.INSERT_ARTIFACT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$UPDATE_ARTIFACT_ID_$eq(String x$1) {
        this.UPDATE_ARTIFACT_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ARTIFACT_BY_ID_$eq(String x$1) {
        this.COUNT_ARTIFACT_BY_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$SELECT_ARTIFACT_BY_PATH_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_PATH = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$DELETE_ARTIFACT_$eq(String x$1) {
        this.DELETE_ARTIFACT = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public String refFromChecksum(String checksum) {
        return checksum;
    }

    @Override
    public void store(Integer pk, String filename, InputStream inputStream) {
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, sha1);
        String tempId = UUID.randomUUID().toString();
        this.insert(tempId, digestInputStream);
        String checksum = JavaCryptoUtils.digest((MessageDigest)sha1);
        boolean exists = ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ARTIFACT_BY_ID(), Number.class, new Object[]{checksum})).intValue() > 0;
        int n = exists ? this.jdbcTemplate().update(this.DELETE_ARTIFACT(), new Object[]{tempId}) : this.jdbcTemplate().update(this.UPDATE_ARTIFACT_ID(), new Object[]{checksum, tempId});
        this.insert(pk, filename, checksum);
    }

    public int insert(String id, InputStream inputStream) {
        return this.jdbcTemplate().update(this.INSERT_ARTIFACT(), ps -> {
            ps.setString(1, id);
            ps.setBinaryStream(2, inputStream);
        });
    }

    @Override
    public void insert(Integer pk, String filename, String reference) {
        this.jdbcTemplate().update(this.INSERT_USAGE(), new Object[]{pk, reference, filename});
    }

    @Override
    public void copy(String fromId, Integer toPk) {
        this.jdbcTemplate().update(this.COPY_USAGE(), new Object[]{toPk, fromId});
    }

    @Override
    public InputStream retrieve(String id) {
        return new InputStream(this, id){
            private final Connection con;
            private final PreparedStatement ps;
            private final ResultSet rs;
            private final InputStream delegate;
            private final /* synthetic */ DbArtifactRepository $outer;

            private Connection con() {
                return this.con;
            }

            private PreparedStatement ps() {
                return this.ps;
            }

            private ResultSet rs() {
                return this.rs;
            }

            private InputStream delegate() {
                return this.delegate;
            }

            public int read() {
                return this.delegate().read();
            }

            public int read(byte[] b, int off, int len) {
                return this.delegate().read(b, off, len);
            }

            public void close() {
                JdbcUtils.closeResultSet((ResultSet)this.rs());
                JdbcUtils.closeStatement((Statement)this.ps());
                DataSourceUtils.releaseConnection((Connection)this.con(), (DataSource)this.$outer.jdbcTemplate().getDataSource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.con = DataSourceUtils.getConnection((DataSource)$outer.jdbcTemplate().getDataSource());
                this.ps = this.con().prepareStatement($outer.SELECT_ARTIFACT_BY_PATH());
                this.ps().setString(1, package$.MODULE$.idToPath(id$2));
                this.rs = this.ps().executeQuery();
                if (!this.rs().next()) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Artifact data not found for: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id$2})), new Object[0]);
                }
                this.delegate = this.rs().getBinaryStream(1);
            }
        };
    }

    @Override
    public String getFilename(String id) {
        return (String)this.jdbcTemplate().queryForObject(this.SELECT_USAGE_FILENAME(), String.class, new Object[]{package$.MODULE$.idToPath(id)});
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().queryForList(this.SELECT_ARTIFACT_BY_USAGE(), String.class, new Object[]{pk}).forEach(artifactId -> {
            block0: {
                int count = ((Number)this.jdbcTemplate().queryForObject(this.COUNT_USAGE(), Number.class, new Object[]{artifactId})).intValue();
                Object object = count > 0 ? BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.DELETE_USAGE(), new Object[]{pk})) : BoxedUnit.UNIT;
                if (count != 1) break block0;
                this.jdbcTemplate().update(this.DELETE_ARTIFACT(), new Object[]{artifactId});
            }
        });
    }

    public DbArtifactRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        DbArtifactQueries.$init$(this);
        DbArtifactUsageQueries.$init$(this);
    }
}

