/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.batch.BatchCommand$;
import com.xebialabs.deployit.core.sql.batch.BatchCommandWithArgs;
import com.xebialabs.deployit.exception.UnknownRevisionException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository$;
import com.xebialabs.deployit.repository.sql.HistoryQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Repository
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001\u0002\b\u0010\u0001iA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005U!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003:\u0011!!\u0005A!b\u0001\n\u0007)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\u0001(\t\u000b9\u0004A\u0011I8\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\tY\r\u0001C!\u0003\u001b\u0014qcQ5ISN$xN]=SKB|7/\u001b;pefLU\u000e\u001d7\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\u000b\u0016\u0003!!W\r\u001d7ps&$(B\u0001\f\u0018\u0003%AXMY5bY\u0006\u00147OC\u0001\u0019\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011$I\u0013\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\u0010\u0013\t!sBA\nDS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002#M%\u0011qe\u0004\u0002\u000f\u0011&\u001cHo\u001c:z#V,'/[3t\u00031QGMY2UK6\u0004H.\u0019;f+\u0005Q\u0003CA\u00165\u001b\u0005a#BA\u0017/\u0003\u0011\u0019wN]3\u000b\u0005=\u0002\u0014\u0001\u00026eE\u000eT!!\r\u001a\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aM\u0001\u0004_J<\u0017BA\u001b-\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u00051Q.\u00199qKJ,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003}}\nqA[1dWN|gN\u0003\u0002A/\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003\u0005n\u0012Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\u0006tc2$\u0015.\u00197fGR,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003!%S!!L\n\n\u0005-C%AC*rY\u0012K\u0017\r\\3di\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0019q\nZ5\u0015\u0005A\u000b\u0006C\u0001\u0012\u0001\u0011\u0015!u\u0001q\u0001GQ\u0011\t6+\u00180\u0011\u0005Q[V\"A+\u000b\u0005Y;\u0016AC1o]>$\u0018\r^5p]*\u0011\u0001,W\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ\u0006'A\u0003cK\u0006t7/\u0003\u0002]+\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002?\u0006qQ.Y5o'FdG)[1mK\u000e$\bFA)b!\t!&-\u0003\u0002d+\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006Q\u001d\u0001\rA\u000b\u0015\u0005INkf-I\u0001h\u0003Ai\u0017-\u001b8KI\n\u001cG+Z7qY\u0006$X\r\u000b\u0002eC\")qg\u0002a\u0001s!\"\u0011nU/lC\u0005a\u0017!\u00045jgR|'/_'baB,'\u000f\u000b\u0002jC\u0006\u0019r-\u001a;WKJ\u001c\u0018n\u001c8SKZL7/[8ogR\u0011\u0001\u000f \t\u0004cZDX\"\u0001:\u000b\u0005M$\u0018\u0001B;uS2T\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xe\n!A*[:u!\tI(0D\u0001\u0012\u0013\tY\u0018CA\rD_:4\u0017nZ;sCRLwN\\%uK6\u0014VM^5tS>t\u0007\"B?\t\u0001\u0004q\u0018AA5e!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004ui!!!\u0002\u000b\u0007\u0005\u001d\u0011$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017i\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\fu\t\u0011CZ3uG\"\u0014VM^5tS>tG)\u0019;b)\u0011\t9\"!\u0016\u0011\tE4\u0018\u0011\u0004\t\u000b9\u0005m\u0011qDA\u0013\u0003\u001fr\u0018bAA\u000f;\t1A+\u001e9mKR\u00022\u0001HA\u0011\u0013\r\t\u0019#\b\u0002\u0004\u0013:$\b\u0003BA\u0014\u0003\u0013rA!!\u000b\u0002D9!\u00111FA \u001d\u0011\ti#!\u0010\u000f\t\u0005=\u00121\b\b\u0005\u0003c\tID\u0004\u0003\u00024\u0005]b\u0002BA\u0002\u0003kI\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\r\t\teD\u0001\u0005E\u0006\u001cX-\u0003\u0003\u0002F\u0005\u001d\u0013a\u00029bG.\fw-\u001a\u0006\u0004\u0003\u0003z\u0011\u0002BA&\u0003\u001b\u0012\u0001bQ5Q\u0017RK\b/\u001a\u0006\u0005\u0003\u000b\n9\u0005E\u0002r\u0003#J1!a\u0015s\u0005!\u0019\u0015\r\\3oI\u0006\u0014\b\"B?\n\u0001\u0004q\u0018aD2sK\u0006$XMU3wSNLwN\\:\u0015\t\u0005m\u0013\u0011\r\t\u0005c\u0006u\u00030C\u0002\u0002`I\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\t\u000f\u0005\r$\u00021\u0001\u0002\u0018\u0005)\u0011\u000e^3ng\u0006a!/Z1e%\u00164\u0018n]5p]V!\u0011\u0011NA8)\u0019\tY'a$\u0002\u0012B!\u0011QNA8\u0019\u0001!q!!\u001d\f\u0005\u0004\t\u0019HA\u0001U#\u0011\t)(a\u001f\u0011\u0007q\t9(C\u0002\u0002zu\u0011qAT8uQ&tw\r\u0005\u0003\u0002~\u0005-UBAA@\u0015\u0011\t\t)a!\u0002\u0007U$WN\u0003\u0003\u0002\u0006\u0006\u001d\u0015aA1qS*\u0019\u0011\u0011R\n\u0002\rAdWoZ5o\u0013\u0011\ti)a \u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0003~\u0017\u0001\u0007a\u0010\u0003\u0004\u0002\u0014.\u0001\rA`\u0001\re\u00164\u0018n]5p]:\u000bW.Z\u0001\fE\u0006$8\r[%og\u0016\u0014H\u000f\u0006\u0006\u0002\u001a\u0006-\u0016qVAZ\u0003\u000f\u0004R\u0001HAN\u0003?K1!!(\u001e\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011UAT\u001b\t\t\u0019KC\u0002\u0002&\"\u000bQAY1uG\"LA!!+\u0002$\n!\")\u0019;dQ\u000e{W.\\1oI^KG\u000f[!sONDq!!,\r\u0001\u0004\t)#\u0001\u0002qW\"9\u0011\u0011\u0017\u0007A\u0002\u0005m\u0014AA2j\u0011\u001d\t)\f\u0004a\u0001\u0003o\u000b1A\\8x!\u0011\tI,a1\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bA\u0001^5nK*\u0019\u0011\u0011\u0019\u001a\u0002\t)|G-Y\u0005\u0005\u0003\u000b\fYL\u0001\u0005ECR,G+[7f\u0011\u0019\tI\r\u0004a\u0001}\u0006AQo]3s\u001d\u0006lW-\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u001f\f)\u000eE\u0002\u001d\u0003#L1!a5\u001e\u0005\u0011)f.\u001b;\t\u000f\u00055V\u00021\u0001\u0002&!2\u0001!!7^\u0003O\u0004B!a7\u0002d6\u0011\u0011Q\u001c\u0006\u0004-\u0006}'bAAqa\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t)/!8\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1mC\t\tI/\u0001\fnC&tGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\r\u0001\u0011Q\u001e\t\u0005\u0003_\f)0\u0004\u0002\u0002r*\u0019\u00111\u001f\u0019\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002x\u0006E(A\u0003*fa>\u001c\u0018\u000e^8ss\u0002")
public class CiHistoryRepositoryImpl
implements CiHistoryRepository,
HistoryQueries {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper mapper;
    private final SqlDialect sqlDialect;
    private String INSERT;
    private String DELETE;
    private String SELECT_CI;
    private String SELECT_REVISIONS;
    private volatile byte bitmap$0;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private String INSERT$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.INSERT = HistoryQueries.INSERT$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String DELETE$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.DELETE = HistoryQueries.DELETE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String SELECT_CI$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SELECT_CI = HistoryQueries.SELECT_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SELECT_CI;
    }

    @Override
    public String SELECT_CI() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SELECT_CI$lzycompute() : this.SELECT_CI;
    }

    private String SELECT_REVISIONS$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SELECT_REVISIONS = HistoryQueries.SELECT_REVISIONS$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SELECT_REVISIONS;
    }

    @Override
    public String SELECT_REVISIONS() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SELECT_REVISIONS$lzycompute() : this.SELECT_REVISIONS;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public List<ConfigurationItemRevision> getVersionRevisions(String id) {
        return this.createRevisions(this.fetchRevisionData(id));
    }

    private List<Tuple4<Object, Integer, Calendar, String>> fetchRevisionData(String id) {
        return this.jdbcTemplate().query(this.SELECT_REVISIONS(), (rs, row) -> {
            Integer pk = (Integer)package$.MODULE$.asCiPKType().apply((Object)BoxesRunTime.boxToInteger((int)rs.getInt(1)));
            Calendar timestamp = com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(rs.getTimestamp(2, com.xebialabs.deployit.core.sql.package$.MODULE$.UTC_CALENDAR()));
            String username = rs.getString(3);
            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)row), (Object)pk, (Object)timestamp, (Object)username);
        }, new Object[]{package$.MODULE$.idToPath(id)});
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ConfigurationItemRevision> createRevisions(List<Tuple4<Object, Integer, Calendar, String>> items) {
        void var3_2;
        ArrayList<ConfigurationItemRevision> result = new ArrayList<ConfigurationItemRevision>(items.size());
        Iterator<Tuple4<Object, Integer, Calendar, String>> itr = items.iterator();
        while (itr.hasNext()) {
            Tuple4<Object, Integer, Calendar, String> tuple4 = itr.next();
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            int row = BoxesRunTime.unboxToInt((Object)tuple4._1());
            Calendar timestamp = (Calendar)tuple4._3();
            String username = (String)tuple4._4();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)row), (Object)timestamp, (Object)username);
            Tuple3 tuple32 = tuple3;
            int row2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Calendar timestamp2 = (Calendar)tuple32._2();
            String username2 = (String)tuple32._3();
            result.add(itr.hasNext() ? new ConfigurationItemRevision(CiHistoryRepository$.MODULE$.indexToRevisionName(row2), timestamp2, username2) : new ConfigurationItemRevision("current", timestamp2, username2));
        }
        return var3_2;
    }

    @Override
    public <T extends ConfigurationItem> T readRevision(String id, String revisionName) {
        String string = revisionName;
        Option option = CiHistoryRepository$.MODULE$.nameRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw CiHistoryRepositoryImpl.throwUnknownRevision$1(revisionName, id);
        }
        String res = (String)((LinearSeqOptimized)option.get()).apply(0);
        int n = new StringOps(Predef$.MODULE$.augmentString(res)).toInt();
        int idx = n;
        List<Tuple4<Object, Integer, Calendar, String>> revisions = this.fetchRevisionData(id);
        if (revisions.size() < idx) {
            throw CiHistoryRepositoryImpl.throwUnknownRevision$1(revisionName, id);
        }
        Integer pk = (Integer)revisions.get(idx)._2();
        List result = this.jdbcTemplate().queryForList(this.SELECT_CI(), String.class, new Object[]{pk, package$.MODULE$.idToPath(id)});
        String ci_json = (String)result.get(0);
        return (T)((ConfigurationItem)this.mapper().readValue(ci_json, ConfigurationItem.class));
    }

    @Override
    public Option<BatchCommandWithArgs> batchInsert(Integer pk, ConfigurationItem ci, DateTime now, String userName) {
        return CiHistoryRepository$.MODULE$.shouldVersion(ci.getId(), ci.getType()) ? new Some((Object)BatchCommand$.MODULE$.apply(this.INSERT(), (Seq)Predef$.MODULE$.wrapRefArray(new Object[]{pk, com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(now), Option$.MODULE$.apply((Object)userName).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<system>"), this.mapper().writerFor(ConfigurationItem.class).writeValueAsString((Object)ci)}))) : None$.MODULE$;
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{pk});
    }

    private static final Nothing$ throwUnknownRevision$1(String revisionName$1, String id$1) {
        throw new UnknownRevisionException("Cannot find revision [%s] for configuration item [%s]", new Object[]{revisionName$1, id$1});
    }

    public CiHistoryRepositoryImpl(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="historyMapper") ObjectMapper mapper, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = mapper;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        HistoryQueries.$init$(this);
    }
}

