/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.lock;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.sql.lock.CiLockQueries;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepository;
import com.xebialabs.deployit.repository.sql.lock.model.CiLock;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\b\u0011\u0001uA\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005k!A!\t\u0001BC\u0002\u0013\r1\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001d\t9\u0003\u0001C!\u0003SAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!1\u0011\u0003\u0001C\u0005\u0003KBq!!\u001d\u0001\t\u0013\t\u0019\b\u0003\u0004\u0012\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003+\u0003A\u0011IAL\u0005Q\u0019\u0015\u000eT8dWJ+\u0007o\\:ji>\u0014\u00180S7qY*\u0011\u0011CE\u0001\u0005Y>\u001c7N\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0003G\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011DG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aG\u0001\u0004G>l7\u0001A\n\u0006\u0001y!\u0003f\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\t\n\u0005\u001d\u0002\"\u0001E\"j\u0019>\u001c7NU3q_NLGo\u001c:z!\t)\u0013&\u0003\u0002+!\ti1)\u001b'pG.\fV/\u001a:jKN\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012q\u0001T8hO&tw-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u00016!\t1t(D\u00018\u0015\tA\u0014(\u0001\u0003d_J,'B\u0001\u001e<\u0003\u0011QGMY2\u000b\u0005qj\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003y\n1a\u001c:h\u0013\t\u0001uG\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\u000bgFdG)[1mK\u000e$X#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005M9%B\u0001\u001d\u0017\u0013\tIeI\u0001\u0006Tc2$\u0015.\u00197fGR\f1b]9m\t&\fG.Z2uA\u00051A(\u001b8jiz\"\"!\u00142\u0015\u00059{\u0005CA\u0013\u0001\u0011\u0015\u0011U\u0001q\u0001EQ\u0011y\u0015k\u0017/\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016AC1o]>$\u0018\r^5p]*\u0011akV\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA6(A\u0003cK\u0006t7/\u0003\u0002['\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002;\u0006qQ.Y5o'FdG)[1mK\u000e$\bFA(`!\t\u0011\u0006-\u0003\u0002b'\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006g\u0015\u0001\r!\u000e\u0015\u0005EF[F-I\u0001f\u0003Ai\u0017-\u001b8KI\n\u001cG+Z7qY\u0006$X\r\u000b\u0002c?\u0006\tB.[:u\u0019>\u001c7n\u001d\"z)\u0006\u001c8.\u00133\u0015\u0005%l\bc\u00016sk:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]r\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005E\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003gR\u0014A\u0001T5ti*\u0011\u0011\u000f\t\t\u0003mjt!a\u001e=\u0011\u00051\u0004\u0013BA=!\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0004\u0003\"\u0002@\u0007\u0001\u0004y\u0018A\u0002;bg.LE\r\u0005\u0003\u0002\u0002\u0005\u0005b\u0002BA\u0002\u0003;qA!!\u0002\u0002\u00189!\u0011qAA\n\u001d\u0011\tI!!\u0005\u000f\t\u0005-\u0011q\u0002\b\u0004Y\u00065\u0011\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\r\t)BF\u0001\u0007K:<\u0017N\\3\n\t\u0005e\u00111D\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0007\u0005Ua#C\u0002r\u0003?QA!!\u0007\u0002\u001c%!\u00111EA\u0013\u0005\u0019!\u0016m]6JI*\u0019\u0011/a\b\u0002\u00191L7\u000f^!mY2{7m[:\u0015\u0003%\f!c\u00197fCJdunY6t\u0005f$\u0016m]6JIR!\u0011qFA\u001b!\ry\u0012\u0011G\u0005\u0004\u0003g\u0001#\u0001B+oSRDQA \u0005A\u0002U\fQb\u00197fCJ\fE\u000e\u001c'pG.\u001cHCAA\u0018\u0003!9W\r\u001e'pG.\u001cH\u0003BA \u0003\u001b\u0002BA\u001b:\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002HA\tQ!\\8eK2LA!a\u0013\u0002F\t11)\u001b'pG.Dq!a\u0014\u000b\u0001\u0004\t\t&\u0001\u0002dSB!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013aA;e[*!\u00111LA/\u0003\r\t\u0007/\u001b\u0006\u0004\u0003?2\u0012A\u00029mk\u001eLg.\u0003\u0003\u0002d\u0005U#!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[R1\u0011qMA7\u0003_\u00022aHA5\u0013\r\tY\u0007\t\u0002\b\u0005>|G.Z1o\u0011\u001d\tye\u0003a\u0001\u0003#BQA`\u0006A\u0002}\fAbY1o%\u0016,g\u000e\u001e:b]R$\u0002\"a\u001a\u0002v\u0005]\u0014\u0011\u0010\u0005\b\u0003\u001fb\u0001\u0019AA)\u0011\u0015qH\u00021\u0001\u0000\u0011\u001d\tY\b\u0004a\u0001\u0003\u007f\t!\u0002\\8dWN4uN]\"j)\u0019\t9'a \u0002\u0014\"9\u0011\u0011Q\u0007A\u0002\u0005\r\u0015aA2jgB1\u0011QQAH\u0003#j!!a\"\u000b\t\u0005%\u00151R\u0001\u0005kRLGN\u0003\u0002\u0002\u000e\u0006!!.\u0019<b\u0013\u0011\t\t*a\"\u0003\u0007M+G\u000fC\u0003\u007f\u001b\u0001\u0007q0\u0001\u0004v]2|7m\u001b\u000b\u0007\u0003_\tI*a'\t\u000f\u0005\u0005e\u00021\u0001\u0002\u0004\")aP\u0004a\u0001\u007f\"2\u0001!a(\\\u0003[\u0003B!!)\u0002*6\u0011\u00111\u0015\u0006\u0004)\u0006\u0015&bAATw\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\tY+a)\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1mC\t\ty+\u0001\fnC&tGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\r\u0001\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011X\u001e\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002>\u0006]&!C\"p[B|g.\u001a8u\u0001")
public class CiLockRepositoryImpl
implements CiLockRepository,
CiLockQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private final String LIST_LOCKS_BY_TASK_ID;
    private final String LIST_ALL_LOCKS;
    private final String CLEAR_LOCKS_WITH_TASK_ID;
    private final String CLEAR_ALL_LOCKS;
    private final String LOCK;
    private final String GET_LOCKS_BY_CI_ID;
    private final String UNLOCK;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CiLockRepositoryImpl ciLockRepositoryImpl = this;
        synchronized (ciLockRepositoryImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String LIST_LOCKS_BY_TASK_ID() {
        return this.LIST_LOCKS_BY_TASK_ID;
    }

    @Override
    public String LIST_ALL_LOCKS() {
        return this.LIST_ALL_LOCKS;
    }

    @Override
    public String CLEAR_LOCKS_WITH_TASK_ID() {
        return this.CLEAR_LOCKS_WITH_TASK_ID;
    }

    @Override
    public String CLEAR_ALL_LOCKS() {
        return this.CLEAR_ALL_LOCKS;
    }

    @Override
    public String LOCK() {
        return this.LOCK;
    }

    @Override
    public String GET_LOCKS_BY_CI_ID() {
        return this.GET_LOCKS_BY_CI_ID;
    }

    @Override
    public String UNLOCK() {
        return this.UNLOCK;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_LOCKS_BY_TASK_ID_$eq(String x$1) {
        this.LIST_LOCKS_BY_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LIST_ALL_LOCKS_$eq(String x$1) {
        this.LIST_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_LOCKS_WITH_TASK_ID_$eq(String x$1) {
        this.CLEAR_LOCKS_WITH_TASK_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$CLEAR_ALL_LOCKS_$eq(String x$1) {
        this.CLEAR_ALL_LOCKS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$LOCK_$eq(String x$1) {
        this.LOCK = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$GET_LOCKS_BY_CI_ID_$eq(String x$1) {
        this.GET_LOCKS_BY_CI_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$lock$CiLockQueries$_setter_$UNLOCK_$eq(String x$1) {
        this.UNLOCK = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public List<String> listLocksByTaskId(String taskId) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.LIST_LOCKS_BY_TASK_ID(), (rs, x$1) -> rs.getString(1), new Object[]{taskId})).asScala()).toList();
    }

    @Override
    public List<String> listAllLocks() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.LIST_ALL_LOCKS(), (rs, x$2) -> rs.getString(1))).asScala()).toList();
    }

    @Override
    public void clearLocksByTaskId(String taskId) {
        this.jdbcTemplate().update(this.CLEAR_LOCKS_WITH_TASK_ID(), new Object[]{taskId});
    }

    @Override
    public void clearAllLocks() {
        this.jdbcTemplate().update(this.CLEAR_ALL_LOCKS());
    }

    public List<CiLock> getLocks(ConfigurationItem ci) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.GET_LOCKS_BY_CI_ID(), (RowMapper)new RowMapper<CiLock>(null){

            public CiLock mapRow(ResultSet rs, int rowNum) {
                return new CiLock(rs.getInt(1), rs.getString(2));
            }
        }, new Object[]{ci.get$internalId()})).asScala()).toList();
    }

    private boolean lock(ConfigurationItem ci, String taskId) {
        List<CiLock> locksForCi = this.getLocks(ci);
        if (!locksForCi.isEmpty()) {
            return this.canReentrant(ci, taskId, locksForCi);
        }
        int res = this.jdbcTemplate().update(this.LOCK(), new Object[]{ci.get$internalId(), taskId});
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Locking ").append(ci.getName()).append(" on ").append(new Date()).toString());
        if (res == 0) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(ci.getName()).append(" already has a lock").toString());
        }
        return res > 0;
    }

    private boolean canReentrant(ConfigurationItem ci, String taskId, List<CiLock> locksForCi) {
        boolean bl;
        if (locksForCi.contains((Object)new CiLock(Predef$.MODULE$.Integer2int(ci.get$internalId()), taskId))) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Current task ").append(taskId).append(" has already locked ").append(ci.getName()).toString());
            bl = true;
        } else {
            locksForCi.find((Function1 & Serializable & scala.Serializable)ciLock -> BoxesRunTime.boxToBoolean((boolean)CiLockRepositoryImpl.$anonfun$canReentrant$2(ci, ciLock))).map((Function1 & Serializable & scala.Serializable)lock -> {
                CiLockRepositoryImpl.$anonfun$canReentrant$3(this, ci, lock);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean lock(Set<ConfigurationItem> cis, String taskId) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(cis).asScala()).forall((Function1 & Serializable & scala.Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)this.lock(ci, taskId)));
    }

    @Override
    public void unlock(Set<ConfigurationItem> cis, String taskId) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(cis).asScala()).foreach((Function1 & Serializable & scala.Serializable)ci -> BoxesRunTime.boxToInteger((int)CiLockRepositoryImpl.$anonfun$unlock$1(this, taskId, ci)));
    }

    public static final /* synthetic */ boolean $anonfun$canReentrant$2(ConfigurationItem ci$2, CiLock ciLock) {
        return ci$2.get$internalId().equals(BoxesRunTime.boxToInteger((int)ciLock.ciId()));
    }

    public static final /* synthetic */ void $anonfun$canReentrant$3(CiLockRepositoryImpl $this, ConfigurationItem ci$2, CiLock lock) {
        $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append(ci$2.getName()).append(" is locked by another task  : ").append(lock.taskId()).toString());
    }

    public static final /* synthetic */ int $anonfun$unlock$1(CiLockRepositoryImpl $this, String taskId$3, ConfigurationItem ci) {
        return $this.jdbcTemplate().update($this.UNLOCK(), new Object[]{ci.get$internalId(), taskId$3});
    }

    public CiLockRepositoryImpl(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        CiLockQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

