/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepository;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\b\u0010\u0001iA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00038\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001c\u0001\u0005\u00029D\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z\tIC)\u001a9m_fLG/\u000f\u00191\u0007&\u0004F.Y2fQ>dG-\u001a:NS\u001e\u0014\u0018\r^5p]V\u0003xM]1eKJT!\u0001E\t\u0002\u000fU\u0004xM]1eK*\u0011!cE\u0001\u0005G>\u0014XM\u0003\u0002\u0015+\u0005AA-\u001a9m_fLGO\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0019\u0001a\u0007\u0013\u0011\u0005q\u0011S\"A\u000f\u000b\u0005Aq\"BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003CM\taa]3sm\u0016\u0014\u0018BA\u0012\u001e\u0005\u001d)\u0006o\u001a:bI\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\bnC&t7k\u00195f[\u0006LeNZ8\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!M\t\u0002\u0007M\fH.\u0003\u00024a\tQ1k\u00195f[\u0006LeNZ8\u0002\u001f5\f\u0017N\\*dQ\u0016l\u0017-\u00138g_\u0002\nAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012a\u000e\t\u0003q\u0001k\u0011!\u000f\u0006\u0003%iR!a\u000f\u001f\u0002\t)$'m\u0019\u0006\u0003{y\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005K$\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0001\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\bCA#I\u001b\u00051%BA$=\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\u0005%3%A\u0007)mCR4wN]7Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\b\u0006B\u0003L+Z\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002Q#\u00069a-Y2u_JL(B\u0001*=\u0003\u0015\u0011W-\u00198t\u0013\t!VJA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\nq+\u0001\fnC&tGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\t)\u0011\f\u0005\u0002M5&\u00111,\u0014\u0002\n\u0003V$xn^5sK\u0012\fAbY5SKB|7/\u001b;pef\u0004\"A\u00182\u000e\u0003}S!!\r1\u000b\u0005\u0005\u001c\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111m\u0018\u0002\r\u0007&\u0014V\r]8tSR|'/\u001f\u0015\u0003\re\u000bQ\u0003\u001d7bG\u0016Dw\u000e\u001c3feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002hU6\t\u0001N\u0003\u0002jA\u0006a\u0001\u000f\\1dK\"|G\u000eZ3sg&\u00111\u000e\u001b\u0002\u0016!2\f7-\u001a5pY\u0012,'OU3q_NLGo\u001c:zQ\t9\u0011,\u0001\u0004=S:LGO\u0010\u000b\b_F48P`A\u0001!\t\u0001\b!D\u0001\u0010\u0011\u0015a\u0003\u00021\u0001/Q\u0011\t8*V:\"\u0003Q\f!\"\\1j]N\u001b\u0007.Z7bQ\t\t\u0018\fC\u00036\u0011\u0001\u0007q\u0007\u000b\u0003w\u0017VC\u0018%A=\u0002!5\f\u0017N\u001c&eE\u000e$V-\u001c9mCR,\u0007F\u0001<Z\u0011\u0015\u0019\u0005\u00021\u0001EQ\u0011Y8*\u0016,)\u0005mL\u0006\"\u0002/\t\u0001\u0004i\u0006F\u0001@Z\u0011\u0015)\u0007\u00021\u0001gQ\r\t\t!W\u0001\n!\u0006;UiX*J5\u0016+\"!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ!!a\u0004\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005M\u0011Q\u0002\u0002\u0004\u0013:$\u0018A\u0003)B\u000f\u0016{6+\u0013.FA\u0005IAm\\+qOJ\fG-\u001a\u000b\u0003\u00037\u0001B!a\u0003\u0002\u001e%!\u0011qDA\u0007\u0005\u001d\u0011un\u001c7fC:\f!C]3bI\u000eKwJ]\"bi\u000eDWI\u001d:peR!\u0011QEA\u001f!\u0019\tY!a\n\u0002,%!\u0011\u0011FA\u0007\u0005\u0019y\u0005\u000f^5p]B!\u0011QFA\u001d\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012aA;e[*\u0019q$!\u000e\u000b\u0007\u0005]2#\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003w\tyCA\tD_:4\u0017nZ;sCRLwN\\%uK6Dq!a\u0010\r\u0001\u0004\t\t%\u0001\u0002jIB!\u00111IA)\u001d\u0011\t)%!\u0014\u0011\t\u0005\u001d\u0013QB\u0007\u0003\u0003\u0013R1!a\u0013\u001a\u0003\u0019a$o\\8u}%!\u0011qJA\u0007\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*!\u0011qJA\u0007\u00039)\bo\u001a:bI\u00164VM]:j_:$\"!a\u0017\u0011\u0007q\ti&C\u0002\u0002`u\u0011qAV3sg&|g\u000e")
public class Deployit900CiPlaceholderMigrationUpgrader
extends Upgrade
implements Logging {
    private final SchemaInfo mainSchemaInfo;
    private final JdbcTemplate jdbcTemplate;
    @Autowired
    private final CiRepository ciRepository;
    @Autowired
    private final PlaceholderRepository placeholderRepository;
    private final int PAGE_SIZE;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Deployit900CiPlaceholderMigrationUpgrader deployit900CiPlaceholderMigrationUpgrader = this;
        synchronized (deployit900CiPlaceholderMigrationUpgrader) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SchemaInfo mainSchemaInfo() {
        return this.mainSchemaInfo;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    private int PAGE_SIZE() {
        return this.PAGE_SIZE;
    }

    public boolean doUpgrade() {
        Integer count = this.ciRepository.count(new SearchParameters().setAncestor("Applications"));
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(53).append("Running placeholder migration on ").append(count).append(" CIs in batches of ").append(this.PAGE_SIZE()).append(".").toString());
        IntRef pagesIndexed = IntRef.create((int)0);
        int totalPages = (Predef$.MODULE$.Integer2int(count) + this.PAGE_SIZE() - 1) / this.PAGE_SIZE();
        while (pagesIndexed.elem < totalPages) {
            SearchParameters params = new SearchParameters().setAncestor("Applications").setPage((long)pagesIndexed.elem).setResultsPerPage((long)this.PAGE_SIZE());
            Buffer existingTypeCiIds = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.list(params)).asScala().flatMap((Function1 & Serializable)ciData -> {
                Some some;
                if (ciData.getType().exists()) {
                    some = new Some((Object)ciData.getId());
                } else {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(56).append("Skipping placeholder migration for '").append(ciData.getId()).append("'. Unknown type: '").append(ciData.getType()).append("'.").toString());
                    some = None$.MODULE$;
                }
                return some;
            });
            List cis = ((IterableOnceOps)existingTypeCiIds.flatMap((Function1 & Serializable)id -> this.readCiOrCatchError((String)id))).toList();
            this.placeholderRepository.savePlaceholders(cis);
            ++pagesIndexed.elem;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(27).append("Completed batch ").append(pagesIndexed$1.elem).append(" / total: ").append(totalPages).append(".").toString());
        }
        return true;
    }

    private Option<ConfigurationItem> readCiOrCatchError(String id) {
        Some some;
        try {
            String x$1 = id;
            Object x$2 = null;
            boolean x$3 = false;
            boolean x$4 = true;
            boolean x$5 = this.ciRepository.read$default$5();
            Some some2 = new Some((Object)this.ciRepository.read(x$1, null, 1, false, x$5));
            some = some2;
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(44).append("Unable to read ConfigurationItem[").append(id).append("]. Reason: ").append(e.getMessage()).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"9.0.0");
    }

    public Deployit900CiPlaceholderMigrationUpgrader(@Autowired @Qualifier(value="mainSchema") SchemaInfo mainSchemaInfo, @Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainTransactionManager") PlatformTransactionManager transactionManager, @Autowired CiRepository ciRepository, @Autowired PlaceholderRepository placeholderRepository) {
        this.mainSchemaInfo = mainSchemaInfo;
        this.jdbcTemplate = jdbcTemplate;
        this.ciRepository = ciRepository;
        this.placeholderRepository = placeholderRepository;
        Logging.$init$((Logging)this);
        this.PAGE_SIZE = 100;
    }
}

