/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.migration.history;

import akka.actor.Props;
import com.xebialabs.deployit.config.CiMigrationConfig;
import com.xebialabs.deployit.migration.history.HistoryMigrationSupervisor$;
import com.xebialabs.deployit.migration.history.HistoryMigrator;
import com.xebialabs.deployit.migration.history.JcrBatchProcessor;
import javax.jcr.Node;
import javax.jcr.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import scala.Function3;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e;Q!\u0001\u0002\t\u00025\t!\u0004S5ti>\u0014\u00180T5he\u0006$\u0018n\u001c8TkB,'O^5t_JT!a\u0001\u0003\u0002\u000f!L7\u000f^8ss*\u0011QAB\u0001\n[&<'/\u0019;j_:T!a\u0002\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRT!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u00035!K7\u000f^8ss6KwM]1uS>t7+\u001e9feZL7o\u001c:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!)Ad\u0004C\u0001;\u0005)\u0001O]8qgR)aDJ\u00161oA\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0006C\u000e$xN\u001d\u0006\u0002G\u0005!\u0011m[6b\u0013\t)\u0003EA\u0003Qe>\u00048\u000fC\u0003(7\u0001\u0007\u0001&\u0001\bcCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8o\u001c:\u0011\u00059I\u0013B\u0001\u0016\u0003\u0005EQ5M\u001d\"bi\u000eD\u0007K]8dKN\u001cxN\u001d\u0005\u0006Ym\u0001\r!L\u0001\t[&<'/\u0019;peB\u0011aBL\u0005\u0003_\t\u0011q\u0002S5ti>\u0014\u00180T5he\u0006$xN\u001d\u0005\u0006cm\u0001\rAM\u0001\u0007G>tg-[4\u0011\u0005M*T\"\u0001\u001b\u000b\u0005E2\u0011B\u0001\u001c5\u0005E\u0019\u0015.T5he\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u0005\u0006qm\u0001\r!O\u0001\u0013iJ\fgn]1di&|g.T1oC\u001e,'\u000f\u0005\u0002;\u00036\t1H\u0003\u0002={\u0005YAO]1og\u0006\u001cG/[8o\u0015\tqt(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0001\u0015aA8sO&\u0011!i\u000f\u0002\u001b!2\fGOZ8s[R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0004\u0005!\t\u0001Ai\u0005\u0002D%!Aqe\u0011B\u0001B\u0003%\u0001\u0006\u0003\u0005-\u0007\n\u0005\t\u0015!\u0003.\u0011!A4I!A!\u0002\u0013I\u0004\"B\rD\t\u0003IE\u0003\u0002&L\u00196\u0003\"AD\"\t\u000b\u001dB\u0005\u0019\u0001\u0015\t\u000b1B\u0005\u0019A\u0017\t\u000baB\u0005\u0019A\u001d\t\u000b=\u001bE\u0011\u0001)\u0002\u000fA\u0014xnY3tgR\u0011\u0011\u000b\u0016\t\u0003'IK!a\u0015\u000b\u0003\u000f\t{w\u000e\\3b]\")QK\u0014a\u0001-\u0006I!-\u0019;dQNK'0\u001a\t\u0003']K!\u0001\u0017\u000b\u0003\u0007%sG\u000f")
public class HistoryMigrationSupervisor {
    private final JcrBatchProcessor batchProcessor;
    private final HistoryMigrator migrator;
    private final PlatformTransactionManager transactionManager;

    public static Props props(JcrBatchProcessor jcrBatchProcessor, HistoryMigrator historyMigrator, CiMigrationConfig ciMigrationConfig, PlatformTransactionManager platformTransactionManager) {
        return HistoryMigrationSupervisor$.MODULE$.props(jcrBatchProcessor, historyMigrator, ciMigrationConfig, platformTransactionManager);
    }

    public boolean process(int batchSize) {
        boolean bl;
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            try {
                bl = this.batchProcessor.processBatch(batchSize, (Function3<Session, String, Seq<Node>, BoxedUnit>)(Function3 & java.io.Serializable & Serializable)(session, id, nodes) -> {
                    this.migrator.migrate(session, id, (Seq<Node>)nodes);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable t) {
                transactionStatus.setRollbackOnly();
                throw t;
            }
        }
        finally {
            if (transactionStatus.isRollbackOnly()) {
                this.transactionManager.rollback(transactionStatus);
            } else {
                this.transactionManager.commit(transactionStatus);
            }
        }
        return bl;
    }

    public HistoryMigrationSupervisor(JcrBatchProcessor batchProcessor, HistoryMigrator migrator, PlatformTransactionManager transactionManager) {
        this.batchProcessor = batchProcessor;
        this.migrator = migrator;
        this.transactionManager = transactionManager;
    }
}

