/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.migration;

import com.xebialabs.deployit.config.CiMigrationConfig;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.metadata.sql.SqlRepositoryMetadataService;
import com.xebialabs.deployit.migration.ArtifactsMigration;
import com.xebialabs.deployit.migration.CiJcrToSqlMigrationStep;
import com.xebialabs.deployit.migration.CiValidatorMigrationStep;
import com.xebialabs.deployit.migration.CleanUpMigrationStep;
import com.xebialabs.deployit.migration.DatabaseArtifactsMigration$;
import com.xebialabs.deployit.migration.FileArtifactsMigration$;
import com.xebialabs.deployit.migration.Inline$;
import com.xebialabs.deployit.migration.JcrToSqlMigrator;
import com.xebialabs.deployit.migration.MetadataJcrToSqlMigrationStep;
import com.xebialabs.deployit.migration.MigrationRepository;
import com.xebialabs.deployit.migration.NewJcrToSqlMigrator;
import com.xebialabs.deployit.migration.Noop$;
import com.xebialabs.deployit.migration.RestartJcrToSqlMigrator;
import com.xebialabs.deployit.migration.SecurityJcrToSqlMigrationStep;
import com.xebialabs.deployit.migration.VersionJcrToSqlMigrationStep;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.FileArtifactDataRepository;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.sql.SqlPermissionService;
import com.xebialabs.deployit.upgrade.sql.SqlRepositoryVersionService;
import java.io.File;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001-\u0011q\"T5he\u0006$xN\u001d$bGR|'/\u001f\u0006\u0003\u0007\u0011\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\btc2\u0014v\u000e\\3TKJ4\u0018nY3\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005e1\"a\u0003*pY\u0016\u001cVM\u001d<jG\u0016D#AE\u000e\u0011\u0005q9S\"A\u000f\u000b\u0005yy\u0012AC1o]>$\u0018\r^5p]*\u0011\u0001%I\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u00113%A\u0003cK\u0006t7O\u0003\u0002%K\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001'\u0003\ry'oZ\u0005\u0003Qu\u0011\u0011\"Q;u_^L'/\u001a3\t\u0011)\u0002!\u0011!Q\u0001\n-\nAc]9m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0017\u0003\r\u0019\u0018\u000f\\\u0005\u0003a5\u0012AcU9m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007FA\u0015\u001c\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014\u0001H:rYJ+\u0007o\\:ji>\u0014\u00180T3uC\u0012\fG/Y*feZL7-\u001a\t\u0003kej\u0011A\u000e\u0006\u0003]]R!\u0001\u000f\u0003\u0002\u00115,G/\u00193bi\u0006L!A\u000f\u001c\u00039M\u000bHNU3q_NLGo\u001c:z\u001b\u0016$\u0018\rZ1uCN+'O^5dK\"\u0012!g\u0007\u0005\t{\u0001\u0011\t\u0011)A\u0005}\u0005Y2/\u001d7SKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016\u0004\"aP\"\u000e\u0003\u0001S!AL!\u000b\u0005\t#\u0011aB;qOJ\fG-Z\u0005\u0003\t\u0002\u00131dU9m%\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,\u0007F\u0001\u001f\u001c\u0011!9\u0005A!A!\u0002\u0013A\u0015aE7jOJ\fG/[8o%\u0016\u0004xn]5u_JL\bCA%K\u001b\u0005\u0011\u0011BA&\u0003\u0005Mi\u0015n\u001a:bi&|gNU3q_NLGo\u001c:zQ\t15\u0004\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0003I!(/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005A\u001bV\"A)\u000b\u0005I\u001b\u0013a\u0003;sC:\u001c\u0018m\u0019;j_:L!\u0001V)\u00035Ac\u0017\r\u001e4pe6$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\t53\u0016L\u0017\t\u00039]K!\u0001W\u000f\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A.\u0002-5\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJD#!T\u000e\t\u0011y\u0003!\u0011!Q\u0001\n}\u000b!#\u0019:uS\u001a\f7\r\u001e*fa>\u001c\u0018\u000e^8ssB\u0011\u0001MZ\u0007\u0002C*\u0011!mY\u0001\nCJ$\u0018NZ1diNT!A\f3\u000b\u0005\u0015$\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q-\u0019\u0002\u0013\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u000b\u0002^7!A!\u000e\u0001B\u0001B\u0003%1.\u0001\u0011d_:4\u0017nZ;sK\u0012\f%\u000f^5gC\u000e$H)\u0019;b%\u0016\u0004xn]5u_JL\bC\u00011m\u0013\ti\u0017M\u0001\fBeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:zQ\tI7\u0004\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0003i1\u0017\u000e\\3BeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z!\t\u0001'/\u0003\u0002tC\nQb)\u001b7f\u0003J$\u0018NZ1di\u0012\u000bG/\u0019*fa>\u001c\u0018\u000e^8ss\"\u0012qn\u0007\u0005\tm\u0002\u0011\t\u0011)A\u0005o\u0006ABMY!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\u0011\u0005\u0001D\u0018BA=b\u0005a!%-\u0011:uS\u001a\f7\r\u001e#bi\u0006\u0014V\r]8tSR|'/\u001f\u0015\u0003knAQ\u0001 \u0001\u0005\u0002u\fa\u0001P5oSRtD\u0003\u0006@\u0000\u0003\u0007\t9!a\u0003\u0002\u0010\u0005M\u0011\u0011DA\u000f\u0003C\t)\u0003\u0005\u0002J\u0001!)1c\u001fa\u0001)!\u0012qp\u0007\u0005\u0006Um\u0004\ra\u000b\u0015\u0004\u0003\u0007Y\u0002\"B\u001a|\u0001\u0004!\u0004fAA\u00047!)Qh\u001fa\u0001}!\u001a\u00111B\u000e\t\u000b\u001d[\b\u0019\u0001%)\u0007\u0005=1\u0004C\u0003Ow\u0002\u0007q\nK\u0003\u0002\u0014YK&\fK\u0002\u0002\u0014mAQAX>A\u0002}C3!!\u0007\u001c\u0011\u0015Q7\u00101\u0001lQ\r\tib\u0007\u0005\u0006an\u0004\r!\u001d\u0015\u0004\u0003CY\u0002\"\u0002<|\u0001\u00049\bfAA\u00137!9\u00111\u0006\u0001\u0005\u0002\u00055\u0012AD2sK\u0006$X-T5he\u0006$xN\u001d\u000b\t\u0003_\t)$!\u0015\u0002bA\u0019\u0011*!\r\n\u0007\u0005M\"A\u0001\tKGJ$vnU9m\u001b&<'/\u0019;pe\"A\u0011qGA\u0015\u0001\u0004\tI$\u0001\tsKB|7/\u001b;pef\u001cuN\u001c4jOB!\u00111HA'\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AB2p]\u001aLwM\u0003\u0003\u0002D\u0005\u0015\u0013\u0001B2pe\u0016TA!a\u0012\u0002J\u0005Q!.Y2le\u0006\u0014'-\u001b;\u000b\u0007\u0005-S%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001f\niD\u0001\tSKB|7/\u001b;pef\u001cuN\u001c4jO\"A\u00111KA\u0015\u0001\u0004\t)&\u0001\u0005uK6\u0004H.\u0019;f!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\t\u0005\u0019!n\u0019:\n\t\u0005}\u0013\u0011\f\u0002\f\u0015\u000e\u0014H+Z7qY\u0006$X\r\u0003\u0005\u0002d\u0005%\u0002\u0019AA3\u0003=i\u0017n\u001a:bi&|gnQ8oM&<\u0007\u0003BA4\u0003Wj!!!\u001b\u000b\u0007\u0005}B!\u0003\u0003\u0002n\u0005%$!E\"j\u001b&<'/\u0019;j_:\u001cuN\u001c4jO\"\u001a\u0001!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e$\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003w\n)HA\u0005D_6\u0004xN\\3oi\u0002")
public class MigratorFactory {
    @Autowired
    private final RoleService sqlRoleService;
    @Autowired
    private final SqlPermissionService sqlPermissionService;
    @Autowired
    private final SqlRepositoryMetadataService sqlRepositoryMetadataService;
    @Autowired
    private final SqlRepositoryVersionService sqlRepositoryVersionService;
    @Autowired
    private final MigrationRepository migrationRepository;
    @Autowired
    @Qualifier(value="mainTransactionManager")
    private final PlatformTransactionManager transactionManager;
    @Autowired
    private final ArtifactRepository artifactRepository;
    @Autowired
    private final ArtifactDataRepository configuredArtifactDataRepository;
    @Autowired
    private final FileArtifactDataRepository fileArtifactDataRepository;
    @Autowired
    private final DbArtifactDataRepository dbArtifactDataRepository;

    public JcrToSqlMigrator createMigrator(RepositoryConfig repositoryConfig, JcrTemplate template, CiMigrationConfig migrationConfig) {
        Tuple2 tuple2;
        DataStore dataStore = repositoryConfig.getDataStore();
        if (migrationConfig.migration().ci().artifactsInline()) {
            tuple2 = new Tuple2((Object)this.configuredArtifactDataRepository, (Object)Inline$.MODULE$);
        } else if (dataStore instanceof FileDataStore) {
            FileDataStore fileDataStore = (FileDataStore)dataStore;
            File source = new File(fileDataStore.getPath());
            File destination = this.fileArtifactDataRepository.root();
            tuple2 = new Tuple2((Object)this.fileArtifactDataRepository, (Object)FileArtifactsMigration$.MODULE$.create(source, destination, !migrationConfig.migration().ci().artifactsMove()));
        } else if (dataStore instanceof DbDataStore) {
            DbDataStore dbDataStore = (DbDataStore)dataStore;
            tuple2 = new Tuple2((Object)this.dbArtifactDataRepository, (Object)DatabaseArtifactsMigration$.MODULE$.create(this.dbArtifactDataRepository, dbDataStore, this.transactionManager, migrationConfig.migration().ci().artifactsBatchSize()));
        } else if (dataStore == null) {
            tuple2 = new Tuple2((Object)this.configuredArtifactDataRepository, (Object)Noop$.MODULE$);
        } else {
            throw new MatchError((Object)dataStore);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ArtifactDataRepository artifactDataRepository = (ArtifactDataRepository)tuple22._1();
        ArtifactsMigration interceptor = (ArtifactsMigration)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)artifactDataRepository, (Object)interceptor);
        Tuple2 tuple24 = tuple23;
        ArtifactDataRepository artifactDataRepository2 = (ArtifactDataRepository)tuple24._1();
        ArtifactsMigration interceptor2 = (ArtifactsMigration)tuple24._2();
        int batchSize = migrationConfig.migration().ci().batchSize();
        File stateFile = new File(migrationConfig.migration().ci().stateFile());
        File errorLogLocation = new File(migrationConfig.migration().ci().errorLogLocation());
        boolean artifactsInline = migrationConfig.migration().ci().artifactsInline();
        return stateFile.exists() ? new RestartJcrToSqlMigrator(new CiJcrToSqlMigrationStep(template, (PermissionEditor)this.sqlPermissionService, this.migrationRepository, this.artifactRepository, artifactDataRepository2, interceptor2, this.transactionManager, batchSize, stateFile, errorLogLocation, artifactsInline)) : new NewJcrToSqlMigrator(new CiValidatorMigrationStep(template, this.transactionManager, batchSize), new CleanUpMigrationStep(this.migrationRepository), new MetadataJcrToSqlMigrationStep(template, this.sqlRepositoryMetadataService), new VersionJcrToSqlMigrationStep(template, this.sqlRepositoryVersionService), new SecurityJcrToSqlMigrationStep(template, this.sqlRoleService, this.sqlPermissionService, this.migrationRepository, this.transactionManager), new CiJcrToSqlMigrationStep(template, (PermissionEditor)this.sqlPermissionService, this.migrationRepository, this.artifactRepository, artifactDataRepository2, interceptor2, this.transactionManager, batchSize, stateFile, errorLogLocation, artifactsInline));
    }

    public MigratorFactory(@Autowired RoleService sqlRoleService, @Autowired SqlPermissionService sqlPermissionService, @Autowired SqlRepositoryMetadataService sqlRepositoryMetadataService, @Autowired SqlRepositoryVersionService sqlRepositoryVersionService, @Autowired MigrationRepository migrationRepository, @Autowired @Qualifier(value="mainTransactionManager") PlatformTransactionManager transactionManager, @Autowired ArtifactRepository artifactRepository, @Autowired ArtifactDataRepository configuredArtifactDataRepository, @Autowired FileArtifactDataRepository fileArtifactDataRepository, @Autowired DbArtifactDataRepository dbArtifactDataRepository) {
        this.sqlRoleService = sqlRoleService;
        this.sqlPermissionService = sqlPermissionService;
        this.sqlRepositoryMetadataService = sqlRepositoryMetadataService;
        this.sqlRepositoryVersionService = sqlRepositoryVersionService;
        this.migrationRepository = migrationRepository;
        this.transactionManager = transactionManager;
        this.artifactRepository = artifactRepository;
        this.configuredArtifactDataRepository = configuredArtifactDataRepository;
        this.fileArtifactDataRepository = fileArtifactDataRepository;
        this.dbArtifactDataRepository = dbArtifactDataRepository;
    }
}

