package com.xebialabs.database.anonymizer.config

import ai.digital.config.AbstractEnvironmentPreparedProcessor
import com.xebialabs.database.anonymizer.{AnonymizerActiveProfiles, AnonymizerContants}
import com.xebialabs.deployit.ServerConfiguration
import org.springframework.boot.{ConfigurableBootstrapContext, SpringApplication}
import org.springframework.core.Ordered
import org.springframework.core.annotation.Order
import org.springframework.core.env.ConfigurableEnvironment

@Order(Ordered.LOWEST_PRECEDENCE)
class AnonymizerEnvironmentPreparedProcessor(application: SpringApplication, args: Array[String]) extends AbstractEnvironmentPreparedProcessor {

  override def environmentPrepared(bootstrapContext: ConfigurableBootstrapContext, environment: ConfigurableEnvironment): Unit =
    if (AnonymizerActiveProfiles.elements.sameElements(environment.getActiveProfiles)) {
      super.environmentPrepared(bootstrapContext, environment)
    }

  override protected def resolveSpringCloudUri(bootstrapContext: ConfigurableBootstrapContext, environment: ConfigurableEnvironment): Option[String] =
    if (ServerConfiguration.getInstance().getSpringCloudExternalConfig()) {
      super.resolveSpringCloudUri(bootstrapContext, environment)
    } else {
      Some(getCentralConfigUrl())
    }

  override protected def propertyResourceName: String = "default-db-anonymizer-env"

  private def getCentralConfigUrl(): String =
    s"${ServerConfiguration.getInstance().getServerUrl}${AnonymizerContants.CENTRAL_CONFIG_PATH}"
}
