/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.xebialabs.database.anonymizer.DatabaseName$;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.core.config.db.DatabaseProperties;
import com.xebialabs.deployit.core.config.db.MainDatabase;
import com.xebialabs.deployit.core.config.db.ReportingProperties;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Enumeration;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\n\u0014\u0001qAQa\t\u0001\u0005\u0002\u0011B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u0015\t\u0013U\u0002\u0001\u0019!a\u0001\n\u00031\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%q\u0005\u00011AA\u0002\u0013\u0005q\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0001)\"Ia\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0015\u0005\u00061\u0002!I!\u0017\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006[\u0002!IA\u001c\u0005\u0006m\u0002!Ia\u001e\u0005\u0006y\u0002!I! \u0005\u0006}\u0002!\ta \u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002P\u0001!\t!!\u0015\u0003%\u0011\u000bG/\u00192bg\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003)U\t!\"\u00198p]fl\u0017N_3s\u0015\t1r#\u0001\u0005eCR\f'-Y:f\u0015\tA\u0012$A\u0005yK\nL\u0017\r\\1cg*\t!$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"A\n\u0002\u00195\f\u0017N\u001c#bi\u0006\u0014\u0017m]3\u0016\u0003%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0005\u0011\u0014'B\u0001\u00180\u0003\u0019\u0019wN\u001c4jO*\u0011\u0001'M\u0001\u0005G>\u0014XM\u0003\u00023/\u0005AA-\u001a9m_fLG/\u0003\u00025W\taQ*Y5o\t\u0006$\u0018MY1tK\u0006\u0001R.Y5o\t\u0006$\u0018MY1tK~#S-\u001d\u000b\u0003oi\u0002\"A\b\u001d\n\u0005ez\"\u0001B+oSRDqaO\u0002\u0002\u0002\u0003\u0007\u0011&A\u0002yIE\nQ\"\\1j]\u0012\u000bG/\u00192bg\u0016\u0004\u0003\u0006\u0002\u0003?\u00196\u0003\"a\u0010&\u000e\u0003\u0001S!!\u0011\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002D\t\u00069a-Y2u_JL(BA#G\u0003\u0015\u0011W-\u00198t\u0015\t9\u0005*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005I\u0015aA8sO&\u00111\n\u0011\u0002\n\u0003V$xn^5sK\u0012\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0003\u0005\u0019\"/\u001a9peRLgn\u001a)s_B,'\u000f^5fgV\t\u0001\u000b\u0005\u0002+#&\u0011!k\u000b\u0002\u0014%\u0016\u0004xN\u001d;j]\u001e\u0004&o\u001c9feRLWm]\u0001\u0018e\u0016\u0004xN\u001d;j]\u001e\u0004&o\u001c9feRLWm]0%KF$\"aN+\t\u000fm2\u0011\u0011!a\u0001!\u0006!\"/\u001a9peRLgn\u001a)s_B,'\u000f^5fg\u0002BCa\u0002 M\u001b\u0006\u0019r-\u001a;Ee&4XM]\"p]:,7\r^5p]R\u0011!L\u0019\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b1a]9m\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u0015\r{gN\\3di&|g\u000eC\u0003d\u0011\u0001\u0007A-A\u0007jgJ+\u0007o\u001c:uS:<GI\u0019\t\u0003=\u0015L!AZ\u0010\u0003\u000f\t{w\u000e\\3b]\u0006AAM\u0019#sSZ,'\u000f\u0006\u0002jYB\u00111L[\u0005\u0003Wr\u0013a\u0001\u0012:jm\u0016\u0014\b\"B2\n\u0001\u0004!\u0017!\u00043c\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0002pkB\u0011\u0001o]\u0007\u0002c*\u0011!OX\u0001\u0005kRLG.\u0003\u0002uc\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b\rT\u0001\u0019\u00013\u0002%\u0011\fG/\u00192bg\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0003qn\u0004\"AK=\n\u0005i\\#A\u0005#bi\u0006\u0014\u0017m]3Qe>\u0004XM\u001d;jKNDQaY\u0006A\u0002\u0011\f\u0011#\u001b8ji\u0016s7M]=qi&|gnS3z)\u00059\u0014aD4fi\u0012\u000bG/\u00192bg\u0016t\u0015-\\3\u0015\t\u0005\u0005\u0011q\u0003\t\u0005\u0003\u0007\t\tB\u0004\u0003\u0002\u0006\u00055\u0001cAA\u0004?5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017Y\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0010}\ta\u0001\u0015:fI\u00164\u0017\u0002BA\n\u0003+\u0011aa\u0015;sS:<'bAA\b?!1\u0011\u0011D\u0007A\u0002i\u000b!bY8o]\u0016\u001cG/[8o\u0003Q)\b\u000fZ1uK\u0012\u000bG/\u00192bg\u0016\u001cuN\u001c4jOR)q'a\b\u00020!9\u0011\u0011\u0004\bA\u0002\u0005\u0005\u0002\u0003BA\u0012\u0003Wi!!!\n\u000b\u0007Y\t9CC\u0002\u0002*!\u000ba\u0001\u001a2v]&$\u0018\u0002BA\u0017\u0003K\u0011!\u0003R1uC\n\f7/Z\"p]:,7\r^5p]\"9\u0011\u0011\u0007\bA\u0002\u0005\u0005\u0011\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0017!F4fi\u0012\u000bG/\u00192bg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u0003C\t9\u0004C\u0003d\u001f\u0001\u0007A-\u0001\u000bhKR$\u0015\r^1cCN,w\n]3sCRLwN\u001c\u000b\u0007\u0003{\tI%a\u0013\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003RA!a\u0011\u0002(\u0005Iq\u000e]3sCRLwN\\\u0005\u0005\u0003\u000f\n\tEA\tECR\f'-Y:f\u001fB,'/\u0019;j_:Dq!!\r\u0011\u0001\u0004\t\t\u0001\u0003\u0004\u0002NA\u0001\r\u0001Z\u0001\fSN$%MU3ge\u0016\u001c\b.A\u000bf]\u0006\u0014G.\u001a\"bi\u000eD\u0007K]8dKN\u001c\u0018N\\4\u0015\u000b]\n\u0019&!\u0016\t\u000f\u0005e\u0011\u00031\u0001\u0002\"!9\u0011qK\tA\u0002\u0005e\u0013!\u00032bi\u000eD7+\u001b>f!\rq\u00121L\u0005\u0004\u0003;z\"aA%oi\"\u001a\u0001!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aG\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003W\n)G\u0001\u0006SKB|7/\u001b;pef\u0004")
public class DatabaseRepository {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingProperties reportingProperties;

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingProperties reportingProperties() {
        return this.reportingProperties;
    }

    public void reportingProperties_$eq(ReportingProperties x$1) {
        this.reportingProperties = x$1;
    }

    private Connection getDriverConnection(boolean isReportingDb) {
        this.initEncryptionKey();
        Driver driver = this.dbDriver(isReportingDb);
        String dbUrl = this.databaseProperties(isReportingDb).dbUrl();
        Connection driverConnection = driver.connect(dbUrl, this.dbCredentials(isReportingDb));
        driverConnection.setAutoCommit(true);
        return driverConnection;
    }

    private Driver dbDriver(boolean isReportingDb) {
        return (Driver)Class.forName(this.databaseProperties(isReportingDb).dbDriverClassname()).newInstance();
    }

    /*
     * WARNING - void declaration
     */
    private Properties dbCredentials(boolean isReportingDb) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("user", this.databaseProperties(isReportingDb).dbUsername());
        properties.put("password", this.databaseProperties(isReportingDb).dbPassword());
        return var2_2;
    }

    private DatabaseProperties databaseProperties(boolean isReportingDb) {
        return isReportingDb && this.reportingProperties().database().hasConfigured() ? this.reportingProperties().database() : this.mainDatabase().database();
    }

    private void initEncryptionKey() {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        ServerConfiguration serverConfiguration = serverConfigFile.loadConfig(false, false, true);
        String repositoryKeyStorePassword = serverConfiguration.getRepositoryKeyStorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
    }

    public String getDatabaseName(Connection connection) {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseProductName().toLowerCase();
    }

    private void updateDatabaseConfig(DatabaseConnection connection, String databaseName) {
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DatabaseName$.MODULE$.POSTGRES();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
                    config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = DatabaseName$.MODULE$.MYSQL();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
                        config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value10 = DatabaseName$.MODULE$.DB2();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
                            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Enumeration.Value value12 = DatabaseName$.MODULE$.DEFAULT();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
                                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
    }

    public DatabaseConnection getDatabaseConnection(boolean isReportingDb) {
        Connection driverConnection = this.getDriverConnection(isReportingDb);
        DatabaseConnection connection = null;
        String databaseName = this.getDatabaseName(driverConnection);
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            connection = new DatabaseConnection(driverConnection, driverConnection.getMetaData().getUserName());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                connection = new DatabaseConnection(driverConnection, "dbo");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                connection = new DatabaseConnection(driverConnection);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.updateDatabaseConfig(connection, databaseName);
        return connection;
    }

    public DatabaseOperation getDatabaseOperation(String databaseName, boolean isDbRefresh) {
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.MSSQL();
        Enumeration.Value value3 = value;
        DatabaseOperation databaseOperation = !(value2 != null ? !value2.equals(value3) : value3 != null) ? (isDbRefresh ? InsertIdentityOperation.REFRESH : InsertIdentityOperation.INSERT) : (isDbRefresh ? DatabaseOperation.REFRESH : DatabaseOperation.INSERT);
        return databaseOperation;
    }

    public void enableBatchProcessing(DatabaseConnection connection, int batchSize) {
        connection.getConfig().setProperty("http://www.dbunit.org/properties/batchSize", (Object)BoxesRunTime.boxToInteger((int)batchSize));
        connection.getConfig().setProperty("http://www.dbunit.org/features/batchedStatements", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

