/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.xebialabs.database.anonymizer.DatabaseName$;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.core.config.db.DatabaseConfig;
import com.xebialabs.deployit.core.config.db.MainDatabase;
import com.xebialabs.deployit.core.config.db.ReportingDatabase;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Enumeration;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\n\u0014\u0001qAQa\t\u0001\u0005\u0002\u0011B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u0015\t\u0013U\u0002\u0001\u0019!a\u0001\n\u00031\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%q\u0005\u00011AA\u0002\u0013\u0005q\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0001)\"Ia\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0015\u0005\u00061\u0002!I!\u0017\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006[\u0002!IA\u001c\u0005\u0006m\u0002!Ia\u001e\u0005\u0006y\u0002!I! \u0005\u0006}\u0002!\ta \u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002P\u0001!\t!!\u0015\u0003%\u0011\u000bG/\u00192bg\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003)U\t!\"\u00198p]fl\u0017N_3s\u0015\t1r#\u0001\u0005eCR\f'-Y:f\u0015\tA\u0012$A\u0005yK\nL\u0017\r\\1cg*\t!$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"A\n\u0002\u00195\f\u0017N\u001c#bi\u0006\u0014\u0017m]3\u0016\u0003%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0005\u0011\u0014'B\u0001\u00180\u0003\u0019\u0019wN\u001c4jO*\u0011\u0001'M\u0001\u0005G>\u0014XM\u0003\u00023/\u0005AA-\u001a9m_fLG/\u0003\u00025W\taQ*Y5o\t\u0006$\u0018MY1tK\u0006\u0001R.Y5o\t\u0006$\u0018MY1tK~#S-\u001d\u000b\u0003oi\u0002\"A\b\u001d\n\u0005ez\"\u0001B+oSRDqaO\u0002\u0002\u0002\u0003\u0007\u0011&A\u0002yIE\nQ\"\\1j]\u0012\u000bG/\u00192bg\u0016\u0004\u0003\u0006\u0002\u0003?\u00196\u0003\"a\u0010&\u000e\u0003\u0001S!!\u0011\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002D\t\u00069a-Y2u_JL(BA#G\u0003\u0015\u0011W-\u00198t\u0015\t9\u0005*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005I\u0015aA8sO&\u00111\n\u0011\u0002\n\u0003V$xn^5sK\u0012\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0003\u0005\u0011\"/\u001a9pg&$xN]=ECR\f'-Y:f+\u0005\u0001\u0006C\u0001\u0016R\u0013\t\u00116FA\tSKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016\faC]3q_NLGo\u001c:z\t\u0006$\u0018MY1tK~#S-\u001d\u000b\u0003oUCqa\u000f\u0004\u0002\u0002\u0003\u0007\u0001+A\nsKB|7/\u001b;pef$\u0015\r^1cCN,\u0007\u0005\u000b\u0003\b}1k\u0015aE4fi\u0012\u0013\u0018N^3s\u0007>tg.Z2uS>tGC\u0001.c!\tY\u0006-D\u0001]\u0015\tif,A\u0002tc2T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000b\rD\u0001\u0019\u00013\u0002\u001b%\u001c(+\u001a9peRLgn\u001a#c!\tqR-\u0003\u0002g?\t9!i\\8mK\u0006t\u0017\u0001\u00033c\tJLg/\u001a:\u0015\u0005%d\u0007CA.k\u0013\tYGL\u0001\u0004Ee&4XM\u001d\u0005\u0006G&\u0001\r\u0001Z\u0001\u000eI\n\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0005=,\bC\u00019t\u001b\u0005\t(B\u0001:_\u0003\u0011)H/\u001b7\n\u0005Q\f(A\u0003)s_B,'\u000f^5fg\")1M\u0003a\u0001I\u0006qA-\u0019;bE\u0006\u001cXmQ8oM&<GC\u0001=|!\tQ\u00130\u0003\u0002{W\tqA)\u0019;bE\u0006\u001cXmQ8oM&<\u0007\"B2\f\u0001\u0004!\u0017!E5oSR,en\u0019:zaRLwN\\&fsR\tq'A\bhKR$\u0015\r^1cCN,g*Y7f)\u0011\t\t!a\u0006\u0011\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\ti\u0001E\u0002\u0002\b}i!!!\u0003\u000b\u0007\u0005-1$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001fy\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010}Aa!!\u0007\u000e\u0001\u0004Q\u0016AC2p]:,7\r^5p]\u0006!R\u000f\u001d3bi\u0016$\u0015\r^1cCN,7i\u001c8gS\u001e$RaNA\u0010\u0003_Aq!!\u0007\u000f\u0001\u0004\t\t\u0003\u0005\u0003\u0002$\u0005-RBAA\u0013\u0015\r1\u0012q\u0005\u0006\u0004\u0003SA\u0015A\u00023ck:LG/\u0003\u0003\u0002.\u0005\u0015\"A\u0005#bi\u0006\u0014\u0017m]3D_:tWm\u0019;j_:Dq!!\r\u000f\u0001\u0004\t\t!\u0001\u0007eCR\f'-Y:f\u001d\u0006lW-A\u000bhKR$\u0015\r^1cCN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\t\u0005\u0005\u0012q\u0007\u0005\u0006G>\u0001\r\u0001Z\u0001\u0015O\u0016$H)\u0019;bE\u0006\u001cXm\u00149fe\u0006$\u0018n\u001c8\u0015\r\u0005u\u0012\u0011JA&!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003O\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0013\u0011\t\u0002\u0012\t\u0006$\u0018MY1tK>\u0003XM]1uS>t\u0007bBA\u0019!\u0001\u0007\u0011\u0011\u0001\u0005\u0007\u0003\u001b\u0002\u0002\u0019\u00013\u0002\u0017%\u001cHI\u0019*fMJ,7\u000f[\u0001\u0016K:\f'\r\\3CCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)\u00159\u00141KA+\u0011\u001d\tI\"\u0005a\u0001\u0003CAq!a\u0016\u0012\u0001\u0004\tI&A\u0005cCR\u001c\u0007nU5{KB\u0019a$a\u0017\n\u0007\u0005usDA\u0002J]RD3\u0001AA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4\r\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005-\u0014Q\r\u0002\u000b%\u0016\u0004xn]5u_JL\b")
public class DatabaseRepository {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingDatabase repositoryDatabase;

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingDatabase repositoryDatabase() {
        return this.repositoryDatabase;
    }

    public void repositoryDatabase_$eq(ReportingDatabase x$1) {
        this.repositoryDatabase = x$1;
    }

    private Connection getDriverConnection(boolean isReportingDb) {
        this.initEncryptionKey();
        Driver driver = this.dbDriver(isReportingDb);
        String dbUrl = this.databaseConfig(isReportingDb).dbUrl();
        Connection driverConnection = driver.connect(dbUrl, this.dbCredentials(isReportingDb));
        driverConnection.setAutoCommit(true);
        return driverConnection;
    }

    private Driver dbDriver(boolean isReportingDb) {
        return (Driver)Class.forName(this.databaseConfig(isReportingDb).dbDriverClassname()).newInstance();
    }

    /*
     * WARNING - void declaration
     */
    private Properties dbCredentials(boolean isReportingDb) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("user", this.databaseConfig(isReportingDb).dbUsername());
        properties.put("password", this.databaseConfig(isReportingDb).dbPassword());
        return var2_2;
    }

    private DatabaseConfig databaseConfig(boolean isReportingDb) {
        return isReportingDb && this.repositoryDatabase().database().hasConfigured() ? this.repositoryDatabase().database() : this.mainDatabase().database();
    }

    private void initEncryptionKey() {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        ServerConfiguration serverConfiguration = serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = serverConfiguration.getRepositoryKeyStorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
    }

    public String getDatabaseName(Connection connection) {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseProductName().toLowerCase();
    }

    private void updateDatabaseConfig(DatabaseConnection connection, String databaseName) {
        org.dbunit.database.DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DatabaseName$.MODULE$.POSTGRES();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
                    config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = DatabaseName$.MODULE$.MYSQL();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
                        config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value10 = DatabaseName$.MODULE$.DB2();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
                            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Enumeration.Value value12 = DatabaseName$.MODULE$.DEFAULT();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
                                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
    }

    public DatabaseConnection getDatabaseConnection(boolean isReportingDb) {
        Connection driverConnection = this.getDriverConnection(isReportingDb);
        DatabaseConnection connection = null;
        String databaseName = this.getDatabaseName(driverConnection);
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            connection = new DatabaseConnection(driverConnection, driverConnection.getMetaData().getUserName());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                connection = new DatabaseConnection(driverConnection, "dbo");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                connection = new DatabaseConnection(driverConnection);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.updateDatabaseConfig(connection, databaseName);
        return connection;
    }

    public DatabaseOperation getDatabaseOperation(String databaseName, boolean isDbRefresh) {
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.MSSQL();
        Enumeration.Value value3 = value;
        DatabaseOperation databaseOperation = !(value2 != null ? !value2.equals(value3) : value3 != null) ? (isDbRefresh ? InsertIdentityOperation.REFRESH : InsertIdentityOperation.INSERT) : (isDbRefresh ? DatabaseOperation.REFRESH : DatabaseOperation.INSERT);
        return databaseOperation;
    }

    public void enableBatchProcessing(DatabaseConnection connection, int batchSize) {
        connection.getConfig().setProperty("http://www.dbunit.org/properties/batchSize", (Object)BoxesRunTime.boxToInteger((int)batchSize));
        connection.getConfig().setProperty("http://www.dbunit.org/features/batchedStatements", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

