/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.DatabaseConfig;
import com.xebialabs.deployit.core.config.JpaUtils$;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.xebialabs.deployit.core.sql.config.DatabaseDriverConfiguration$;
import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Configuration
@EnableTransactionManagement
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\f\u0019\u0001\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006+\u0002!\t\u0001\u0010\u0005\u0006/\u0002!I\u0001\u0017\u0005\u0006K\u0002!\tA\u001a\u0005\u0006[\u0002!\tA\u001a\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006q\u0002!\t!\u001f\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002f\u0001!\t!!\u0016\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u0010\u0001\u0005\u0002\u0005-\u0004bBAB\u0001\u0011%\u0011QQ\u0004\b\u0003KC\u0002\u0012AAT\r\u00199\u0002\u0004#\u0001\u0002*\"1qG\u0005C\u0001\u0003WCq!!,\u0013\t\u0003\ty\u000bC\u0004\u0002PJ!I!!5\t\u000f\u0005}'\u0003\"\u0001\u0002b\n\u00012+\u001d7D_:4\u0017nZ;sCRLwN\u001c\u0006\u00033i\taaY8oM&<'BA\u000e\u001d\u0003\u0011\u0019wN]3\u000b\u0005uq\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005}\u0001\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\t\u0013aA2p[\u000e\u00011c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003=\n\u0001b\u001a:jujdW\rZ\u0005\u0003c1\u0012q\u0001T8hO&tw-A\u0005yY\u0012\u001cuN\u001c4jOB\u0011A'N\u0007\u00021%\u0011a\u0007\u0007\u0002\n12$7i\u001c8gS\u001e\fa\u0001P5oSRtDCA\u001d;!\t!\u0004\u0001C\u00033\u0005\u0001\u00071'\u0001\bnC&tG)\u0019;b'>,(oY3\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u0007M\fHNC\u0001C\u0003\u0015Q\u0017M^1y\u0013\t!uH\u0001\u0006ECR\f7k\\;sG\u0016DCa\u0001$S'B\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u000bC:tw\u000e^1uS>t'BA&M\u0003\u001d\u0019wN\u001c;fqRT!!\u0014(\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aT\u0001\u0004_J<\u0017BA)I\u0005\u0011\u0011U-\u00198\u0002\u001b\u0011,7\u000f\u001e:ps6+G\u000f[8eC\u0005!\u0016!B2m_N,\u0017a\u0005:fa>\u0014H/\u001b8h\t\u0006$\u0018mU8ve\u000e,\u0007\u0006\u0002\u0003G%N\u000ba#\u001b8tiJ,X.\u001a8uK\u0012$\u0015\r^1T_V\u00148-\u001a\u000b\u00033\u000e\u0004\"AW1\u000e\u0003mS!\u0001X/\u0002\t)$'m\u0019\u0006\u0003=~\u000bq!\\3ue&\u001c7O\u0003\u0002aA\u0005)A/\u001d3fm&\u0011!m\u0017\u0002\u0017\u0013:\u001cHO];nK:$X\r\u001a#bi\u0006\u001cv.\u001e:dK\")A-\u0002a\u0001{\u0005QA-\u0019;b'>,(oY3\u0002\u001d5\f\u0017N\\*rY\u0012K\u0017\r\\3diV\tq\r\u0005\u0002iU6\t\u0011N\u0003\u0002A5%\u00111.\u001b\u0002\u000b'FdG)[1mK\u000e$\bF\u0001\u0004G\u0003M\u0011X\r]8si&twmU9m\t&\fG.Z2uQ\t9a)\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uKV\t\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002\u001ci*\u0011A\fT\u0005\u0003mN\u0014AB\u00133cGR+W\u000e\u001d7bi\u0016D#\u0001\u0003$\u0002)\u0015tG/\u001b;z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z)\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006\u0019!\u000e]1\u000b\u0005}d\u0015aA8s[&\u0019\u00111\u0001?\u0003A\u0005\u00137\u000f\u001e:bGR,e\u000e^5us6\u000bg.Y4fe\u001a\u000b7\r^8ss\n+\u0017M\u001c\u0015\u0003\u0013\u0019\u000b\u0001cZ3u\u0015B\f\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005-\u0011\u0011GA\u001b!\u001d\ti!a\u0006\u0002\u001c\u0011j!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005kRLGN\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003O\u00012!!\t'\u001b\t\t\u0019CC\u0002\u0002&\t\na\u0001\u0010:p_Rt\u0014bAA\u0015M\u00051\u0001K]3eK\u001aLA!!\f\u00020\t11\u000b\u001e:j]\u001eT1!!\u000b'\u0011\u001d\t\u0019D\u0003a\u0001\u00037\tq\u0002\u001a:jm\u0016\u00148\t\\1tg:\u000bW.\u001a\u0005\b\u0003oQ\u0001\u0019AA\u001d\u0003\t)W\u000eE\u0002|\u0003wI1!!\u0010}\u0005\u0019bunY1m\u0007>tG/Y5oKJ,e\u000e^5us6\u000bg.Y4fe\u001a\u000b7\r^8ss\n+\u0017M\\\u0001\u0015Kb\u001cW\r\u001d;j_:$&/\u00198tY\u0006$\u0018n\u001c8\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001bj!!a\u0012\u000b\u0007%\u000bIEC\u0002\u0002L1\u000b1\u0001Z1p\u0013\u0011\ty%a\u0012\u0003YA+'o]5ti\u0016t7-Z#yG\u0016\u0004H/[8o)J\fgn\u001d7bi&|g\u000eU8tiB\u0013xnY3tg>\u0014\bFA\u0006G\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014XCAA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\u0019\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\t'a\u0017\u00035Ac\u0017\r\u001e4pe6$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u000511\u0015a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'\u000f\u000b\u0002\u000e\r\u00061\u0012N\\5uS\u0006d\u0017N_3NC&tG)\u0019;bE\u0006\u001cX\r\u0006\u0002\u0002nA\u0019Q%a\u001c\n\u0007\u0005EdE\u0001\u0003V]&$\bf\u0001\b\u0002vA!\u0011qOA>\u001b\t\tIH\u0003\u0002J\u0003&!\u0011QPA=\u00055\u0001vn\u001d;D_:\u001cHO];di\u0006Y\u0012N\\5uS\u0006d\u0017N_3SKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016D3aDA;\u0003=)\b\u000fZ1uK2K\u0017/^5cCN,G\u0003CA7\u0003\u000f\u000bY)!$\t\u000f\u0005%\u0005\u00031\u0001\u0002\u001c\u000511o\u00195f[\u0006DQ\u0001\u001a\tA\u0002uBa!a$\u0011\u0001\u00049\u0017a\u00023jC2,7\r\u001e\u0015\u0004\u0001\u0005M\u0005\u0003BAK\u00033k!!a&\u000b\u0007%\u000bY&\u0003\u0003\u0002\u001c\u0006]%aG#oC\ndW\r\u0016:b]N\f7\r^5p]6\u000bg.Y4f[\u0016tG\u000fK\u0002\u0001\u0003?\u00032aRAQ\u0013\r\t\u0019\u000b\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002!M\u000bHnQ8oM&<WO]1uS>t\u0007C\u0001\u001b\u0013'\t\u0011B\u0005\u0006\u0002\u0002(\u0006\u0001\u0002.[6be&$\u0015\r^1T_V\u00148-\u001a\u000b\u0007\u0003c\u000b\t-a3\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u00061\u0001.[6be&T1!a/!\u0003\u0019Q\u0018\r\u001f=fe&!\u0011qXA[\u0005AA\u0015n[1sS\u0012\u000bG/Y*pkJ\u001cW\rC\u0004\u0002DR\u0001\r!!2\u0002\u0011\u0011\fG/\u00192bg\u0016\u00042\u0001NAd\u0013\r\tI\r\u0007\u0002\u000f\t\u0006$\u0018MY1tK\u000e{gNZ5h\u0011\u001d\ti\r\u0006a\u0001\u00037\tAA\\1nK\u0006a\u0001.[6be&\u001cuN\u001c4jOR1\u00111[Am\u00037\u0004B!a-\u0002V&!\u0011q[A[\u00051A\u0015n[1sS\u000e{gNZ5h\u0011\u0019IR\u00031\u0001\u0002F\"9\u0011Q\\\u000bA\u0002\u0005m\u0011\u0001\u00039p_2t\u0015-\\3\u0002!1L\u0017/^5cCN,7i\u001c8uKb$HCBA\u000e\u0003G\f)\u000f\u0003\u0004\u0002\u0010Z\u0001\ra\u001a\u0005\b\u0003O4\u0002\u0019AAu\u0003\r\u0019wN\u001c\t\u0005\u0003W\fy/\u0004\u0002\u0002n*\u0019\u0001)a\u0005\n\t\u0005E\u0018Q\u001e\u0002\u000b\u0007>tg.Z2uS>t\u0007")
public class SqlConfiguration
implements Logging {
    private final XldConfig xldConfig;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect sqlDialect, Connection connection) {
        return SqlConfiguration$.MODULE$.liquibaseContext(sqlDialect, connection);
    }

    public static HikariDataSource hikariDataSource(DatabaseConfig databaseConfig, String string) {
        return SqlConfiguration$.MODULE$.hikariDataSource(databaseConfig, string);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.repository().database(), "MainPool"));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.reporting().database(), "ReportingPool"));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect mainSqlDialect() {
        void var1_1;
        DatabaseDriverConfiguration$.MODULE$.mainDatabaseDriverClassName_$eq(this.xldConfig.repository().database().driverClassname());
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Detected SQL dialect for main: ").append(dialect).append(".").toString());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect reportingSqlDialect() {
        void var1_1;
        DatabaseDriverConfiguration$.MODULE$.reportingDatabaseDriverClassName_$eq(this.xldConfig.reporting().database().driverClassname());
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Detected SQL dialect for reporting: ").append(dialect).append(".").toString());
        return var1_1;
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new DeployJdbcTemplate(this.mainDataSource(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public AbstractEntityManagerFactoryBean entityManagerFactory() {
        void var1_1;
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.mainDataSource());
        em.setJpaPropertyMap(this.getJpaProperties(this.xldConfig.repository().database().driverClassname(), em));
        em.setPackagesToScan(new String[]{"com.xebialabs.deployit"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getJpaProperties(String driverClassName, LocalContainerEntityManagerFactoryBean em) {
        void var3_3;
        Map properties = em.getJpaPropertyMap();
        String string = driverClassName.contains(JpaUtils$.MODULE$.DERBY_JDBC_DRIVER_CLASS_PATTERN()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DERBY_DIALECT_CLASS()) : (driverClassName.contains(JpaUtils$.MODULE$.DB2_JDBC_DRIVER_CLASS_PATTER()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DB2_DIALECT_CLASS()) : BoxedUnit.UNIT);
        return var3_3;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/main-schema.yaml", this.mainDataSource(), this.mainSqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/reporting-schema.yaml", this.reportingDataSource(), this.reportingSqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    public SqlConfiguration(XldConfig xldConfig) {
        this.xldConfig = xldConfig;
        Logging.$init$((Logging)this);
    }
}

